/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterPredicate;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterPredicateBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterPredicateFluentImpl;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpec;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpecFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PrioritizerPolicy;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PrioritizerPolicyBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PrioritizerPolicyFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PlacementSpecFluentImpl<A extends PlacementSpecFluent<A>>
extends BaseFluent<A>
implements PlacementSpecFluent<A> {
    private List<String> clusterSets = new ArrayList<String>();
    private Integer numberOfClusters;
    private ArrayList<ClusterPredicateBuilder> predicates = new ArrayList();
    private PrioritizerPolicyBuilder prioritizerPolicy;

    public PlacementSpecFluentImpl() {
    }

    public PlacementSpecFluentImpl(PlacementSpec instance) {
        if (instance != null) {
            this.withClusterSets(instance.getClusterSets());
            this.withNumberOfClusters(instance.getNumberOfClusters());
            this.withPredicates(instance.getPredicates());
            this.withPrioritizerPolicy(instance.getPrioritizerPolicy());
        }
    }

    @Override
    public A addToClusterSets(int index, String item) {
        if (this.clusterSets == null) {
            this.clusterSets = new ArrayList<String>();
        }
        this.clusterSets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToClusterSets(int index, String item) {
        if (this.clusterSets == null) {
            this.clusterSets = new ArrayList<String>();
        }
        this.clusterSets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToClusterSets(String ... items) {
        if (this.clusterSets == null) {
            this.clusterSets = new ArrayList<String>();
        }
        for (String item : items) {
            this.clusterSets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToClusterSets(Collection<String> items) {
        if (this.clusterSets == null) {
            this.clusterSets = new ArrayList<String>();
        }
        for (String item : items) {
            this.clusterSets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusterSets(String ... items) {
        for (String item : items) {
            if (this.clusterSets == null) continue;
            this.clusterSets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClusterSets(Collection<String> items) {
        for (String item : items) {
            if (this.clusterSets == null) continue;
            this.clusterSets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getClusterSets() {
        return this.clusterSets;
    }

    @Override
    public String getClusterSet(int index) {
        return this.clusterSets.get(index);
    }

    @Override
    public String getFirstClusterSet() {
        return this.clusterSets.get(0);
    }

    @Override
    public String getLastClusterSet() {
        return this.clusterSets.get(this.clusterSets.size() - 1);
    }

    @Override
    public String getMatchingClusterSet(Predicate<String> predicate) {
        for (String item : this.clusterSets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingClusterSet(Predicate<String> predicate) {
        for (String item : this.clusterSets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClusterSets(List<String> clusterSets) {
        if (clusterSets != null) {
            this.clusterSets = new ArrayList<String>();
            for (String item : clusterSets) {
                this.addToClusterSets(item);
            }
        } else {
            this.clusterSets = null;
        }
        return (A)this;
    }

    @Override
    public A withClusterSets(String ... clusterSets) {
        if (this.clusterSets != null) {
            this.clusterSets.clear();
            this._visitables.remove((Object)"clusterSets");
        }
        if (clusterSets != null) {
            for (String item : clusterSets) {
                this.addToClusterSets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterSets() {
        return this.clusterSets != null && !this.clusterSets.isEmpty();
    }

    @Override
    public Integer getNumberOfClusters() {
        return this.numberOfClusters;
    }

    @Override
    public A withNumberOfClusters(Integer numberOfClusters) {
        this.numberOfClusters = numberOfClusters;
        return (A)this;
    }

    @Override
    public Boolean hasNumberOfClusters() {
        return this.numberOfClusters != null;
    }

    @Override
    public A addToPredicates(int index, ClusterPredicate item) {
        if (this.predicates == null) {
            this.predicates = new ArrayList();
        }
        ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
        if (index < 0 || index >= this.predicates.size()) {
            this._visitables.get((Object)"predicates").add(builder);
            this.predicates.add(builder);
        } else {
            this._visitables.get((Object)"predicates").add(index, builder);
            this.predicates.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToPredicates(int index, ClusterPredicate item) {
        if (this.predicates == null) {
            this.predicates = new ArrayList();
        }
        ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
        if (index < 0 || index >= this.predicates.size()) {
            this._visitables.get((Object)"predicates").add(builder);
            this.predicates.add(builder);
        } else {
            this._visitables.get((Object)"predicates").set(index, builder);
            this.predicates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPredicates(ClusterPredicate ... items) {
        if (this.predicates == null) {
            this.predicates = new ArrayList();
        }
        for (ClusterPredicate item : items) {
            ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
            this._visitables.get((Object)"predicates").add(builder);
            this.predicates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPredicates(Collection<ClusterPredicate> items) {
        if (this.predicates == null) {
            this.predicates = new ArrayList();
        }
        for (ClusterPredicate item : items) {
            ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
            this._visitables.get((Object)"predicates").add(builder);
            this.predicates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPredicates(ClusterPredicate ... items) {
        for (ClusterPredicate item : items) {
            ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
            this._visitables.get((Object)"predicates").remove(builder);
            if (this.predicates == null) continue;
            this.predicates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPredicates(Collection<ClusterPredicate> items) {
        for (ClusterPredicate item : items) {
            ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
            this._visitables.get((Object)"predicates").remove(builder);
            if (this.predicates == null) continue;
            this.predicates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPredicates(Predicate<ClusterPredicateBuilder> predicate) {
        if (this.predicates == null) {
            return (A)this;
        }
        Iterator<ClusterPredicateBuilder> each = this.predicates.iterator();
        List visitables = this._visitables.get((Object)"predicates");
        while (each.hasNext()) {
            ClusterPredicateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterPredicate> getPredicates() {
        return this.predicates != null ? PlacementSpecFluentImpl.build(this.predicates) : null;
    }

    @Override
    public List<ClusterPredicate> buildPredicates() {
        return this.predicates != null ? PlacementSpecFluentImpl.build(this.predicates) : null;
    }

    @Override
    public ClusterPredicate buildPredicate(int index) {
        return this.predicates.get(index).build();
    }

    @Override
    public ClusterPredicate buildFirstPredicate() {
        return this.predicates.get(0).build();
    }

    @Override
    public ClusterPredicate buildLastPredicate() {
        return this.predicates.get(this.predicates.size() - 1).build();
    }

    @Override
    public ClusterPredicate buildMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
        for (ClusterPredicateBuilder item : this.predicates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
        for (ClusterPredicateBuilder item : this.predicates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPredicates(List<ClusterPredicate> predicates) {
        if (this.predicates != null) {
            this._visitables.get((Object)"predicates").clear();
        }
        if (predicates != null) {
            this.predicates = new ArrayList();
            for (ClusterPredicate item : predicates) {
                this.addToPredicates(item);
            }
        } else {
            this.predicates = null;
        }
        return (A)this;
    }

    @Override
    public A withPredicates(ClusterPredicate ... predicates) {
        if (this.predicates != null) {
            this.predicates.clear();
            this._visitables.remove((Object)"predicates");
        }
        if (predicates != null) {
            for (ClusterPredicate item : predicates) {
                this.addToPredicates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPredicates() {
        return this.predicates != null && !this.predicates.isEmpty();
    }

    @Override
    public PlacementSpecFluent.PredicatesNested<A> addNewPredicate() {
        return new PredicatesNestedImpl();
    }

    @Override
    public PlacementSpecFluent.PredicatesNested<A> addNewPredicateLike(ClusterPredicate item) {
        return new PredicatesNestedImpl(-1, item);
    }

    @Override
    public PlacementSpecFluent.PredicatesNested<A> setNewPredicateLike(int index, ClusterPredicate item) {
        return new PredicatesNestedImpl(index, item);
    }

    @Override
    public PlacementSpecFluent.PredicatesNested<A> editPredicate(int index) {
        if (this.predicates.size() <= index) {
            throw new RuntimeException("Can't edit predicates. Index exceeds size.");
        }
        return this.setNewPredicateLike(index, this.buildPredicate(index));
    }

    @Override
    public PlacementSpecFluent.PredicatesNested<A> editFirstPredicate() {
        if (this.predicates.size() == 0) {
            throw new RuntimeException("Can't edit first predicates. The list is empty.");
        }
        return this.setNewPredicateLike(0, this.buildPredicate(0));
    }

    @Override
    public PlacementSpecFluent.PredicatesNested<A> editLastPredicate() {
        int index = this.predicates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last predicates. The list is empty.");
        }
        return this.setNewPredicateLike(index, this.buildPredicate(index));
    }

    @Override
    public PlacementSpecFluent.PredicatesNested<A> editMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.predicates.size(); ++i) {
            if (!predicate.test(this.predicates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching predicates. No match found.");
        }
        return this.setNewPredicateLike(index, this.buildPredicate(index));
    }

    @Override
    @Deprecated
    public PrioritizerPolicy getPrioritizerPolicy() {
        return this.prioritizerPolicy != null ? this.prioritizerPolicy.build() : null;
    }

    @Override
    public PrioritizerPolicy buildPrioritizerPolicy() {
        return this.prioritizerPolicy != null ? this.prioritizerPolicy.build() : null;
    }

    @Override
    public A withPrioritizerPolicy(PrioritizerPolicy prioritizerPolicy) {
        this._visitables.get((Object)"prioritizerPolicy").remove(this.prioritizerPolicy);
        if (prioritizerPolicy != null) {
            this.prioritizerPolicy = new PrioritizerPolicyBuilder(prioritizerPolicy);
            this._visitables.get((Object)"prioritizerPolicy").add(this.prioritizerPolicy);
        } else {
            this.prioritizerPolicy = null;
            this._visitables.get((Object)"prioritizerPolicy").remove(this.prioritizerPolicy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPrioritizerPolicy() {
        return this.prioritizerPolicy != null;
    }

    @Override
    public PlacementSpecFluent.PrioritizerPolicyNested<A> withNewPrioritizerPolicy() {
        return new PrioritizerPolicyNestedImpl();
    }

    @Override
    public PlacementSpecFluent.PrioritizerPolicyNested<A> withNewPrioritizerPolicyLike(PrioritizerPolicy item) {
        return new PrioritizerPolicyNestedImpl(item);
    }

    @Override
    public PlacementSpecFluent.PrioritizerPolicyNested<A> editPrioritizerPolicy() {
        return this.withNewPrioritizerPolicyLike(this.getPrioritizerPolicy());
    }

    @Override
    public PlacementSpecFluent.PrioritizerPolicyNested<A> editOrNewPrioritizerPolicy() {
        return this.withNewPrioritizerPolicyLike(this.getPrioritizerPolicy() != null ? this.getPrioritizerPolicy() : new PrioritizerPolicyBuilder().build());
    }

    @Override
    public PlacementSpecFluent.PrioritizerPolicyNested<A> editOrNewPrioritizerPolicyLike(PrioritizerPolicy item) {
        return this.withNewPrioritizerPolicyLike(this.getPrioritizerPolicy() != null ? this.getPrioritizerPolicy() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlacementSpecFluentImpl that = (PlacementSpecFluentImpl)o;
        if (!Objects.equals(this.clusterSets, that.clusterSets)) {
            return false;
        }
        if (!Objects.equals(this.numberOfClusters, that.numberOfClusters)) {
            return false;
        }
        if (!Objects.equals(this.predicates, that.predicates)) {
            return false;
        }
        return Objects.equals(this.prioritizerPolicy, that.prioritizerPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.clusterSets, this.numberOfClusters, this.predicates, this.prioritizerPolicy, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterSets != null && !this.clusterSets.isEmpty()) {
            sb.append("clusterSets:");
            sb.append(this.clusterSets + ",");
        }
        if (this.numberOfClusters != null) {
            sb.append("numberOfClusters:");
            sb.append(this.numberOfClusters + ",");
        }
        if (this.predicates != null) {
            sb.append("predicates:");
            sb.append(this.predicates + ",");
        }
        if (this.prioritizerPolicy != null) {
            sb.append("prioritizerPolicy:");
            sb.append(this.prioritizerPolicy);
        }
        sb.append("}");
        return sb.toString();
    }

    class PrioritizerPolicyNestedImpl<N>
    extends PrioritizerPolicyFluentImpl<PlacementSpecFluent.PrioritizerPolicyNested<N>>
    implements PlacementSpecFluent.PrioritizerPolicyNested<N>,
    Nested<N> {
        PrioritizerPolicyBuilder builder;

        PrioritizerPolicyNestedImpl(PrioritizerPolicy item) {
            this.builder = new PrioritizerPolicyBuilder(this, item);
        }

        PrioritizerPolicyNestedImpl() {
            this.builder = new PrioritizerPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlacementSpecFluentImpl.this.withPrioritizerPolicy(this.builder.build());
        }

        @Override
        public N endPrioritizerPolicy() {
            return this.and();
        }
    }

    class PredicatesNestedImpl<N>
    extends ClusterPredicateFluentImpl<PlacementSpecFluent.PredicatesNested<N>>
    implements PlacementSpecFluent.PredicatesNested<N>,
    Nested<N> {
        ClusterPredicateBuilder builder;
        int index;

        PredicatesNestedImpl(int index, ClusterPredicate item) {
            this.index = index;
            this.builder = new ClusterPredicateBuilder(this, item);
        }

        PredicatesNestedImpl() {
            this.index = -1;
            this.builder = new ClusterPredicateBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlacementSpecFluentImpl.this.setToPredicates(this.index, this.builder.build());
        }

        @Override
        public N endPredicate() {
            return this.and();
        }
    }
}

