package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrioritizerConfigBuilder extends PrioritizerConfigFluentImpl<PrioritizerConfigBuilder> implements VisitableBuilder<PrioritizerConfig,PrioritizerConfigBuilder>{
  public PrioritizerConfigBuilder() {
    this(false);
  }
  public PrioritizerConfigBuilder(Boolean validationEnabled) {
    this(new PrioritizerConfig(), validationEnabled);
  }
  public PrioritizerConfigBuilder(PrioritizerConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public PrioritizerConfigBuilder(PrioritizerConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PrioritizerConfig(), validationEnabled);
  }
  public PrioritizerConfigBuilder(PrioritizerConfigFluent<?> fluent,PrioritizerConfig instance) {
    this(fluent, instance, false);
  }
  public PrioritizerConfigBuilder(PrioritizerConfigFluent<?> fluent,PrioritizerConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withWeight(instance.getWeight());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PrioritizerConfigBuilder(PrioritizerConfig instance) {
    this(instance,false);
  }
  public PrioritizerConfigBuilder(PrioritizerConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withWeight(instance.getWeight());
    }
    this.validationEnabled = validationEnabled; 
  }
  PrioritizerConfigFluent<?> fluent;
  Boolean validationEnabled;
  public PrioritizerConfig build() {
    PrioritizerConfig buildable = new PrioritizerConfig(fluent.getName(),fluent.getWeight());
    return buildable;
  }
  
}