package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementStatusBuilder extends PlacementStatusFluentImpl<PlacementStatusBuilder> implements VisitableBuilder<PlacementStatus,PlacementStatusBuilder>{
  public PlacementStatusBuilder() {
    this(false);
  }
  public PlacementStatusBuilder(Boolean validationEnabled) {
    this(new PlacementStatus(), validationEnabled);
  }
  public PlacementStatusBuilder(PlacementStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementStatusBuilder(PlacementStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PlacementStatus(), validationEnabled);
  }
  public PlacementStatusBuilder(PlacementStatusFluent<?> fluent,PlacementStatus instance) {
    this(fluent, instance, false);
  }
  public PlacementStatusBuilder(PlacementStatusFluent<?> fluent,PlacementStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withNumberOfSelectedClusters(instance.getNumberOfSelectedClusters());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlacementStatusBuilder(PlacementStatus instance) {
    this(instance,false);
  }
  public PlacementStatusBuilder(PlacementStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withNumberOfSelectedClusters(instance.getNumberOfSelectedClusters());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlacementStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PlacementStatus build() {
    PlacementStatus buildable = new PlacementStatus(fluent.getConditions(),fluent.getNumberOfSelectedClusters());
    return buildable;
  }
  
}