package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlacementDecisionFluentImpl<A extends PlacementDecisionFluent<A>> extends BaseFluent<A> implements PlacementDecisionFluent<A>{
  public PlacementDecisionFluentImpl() {
  }
  public PlacementDecisionFluentImpl(PlacementDecision instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private PlacementDecisionStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public PlacementDecisionFluentImpl.MetadataNested<A> withNewMetadata() {
    return new PlacementDecisionFluentImpl.MetadataNestedImpl();
  }
  public PlacementDecisionFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new PlacementDecisionFluentImpl.MetadataNestedImpl(item);
  }
  public PlacementDecisionFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public PlacementDecisionFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public PlacementDecisionFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public PlacementDecisionStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public PlacementDecisionStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(PlacementDecisionStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new PlacementDecisionStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public PlacementDecisionFluentImpl.StatusNested<A> withNewStatus() {
    return new PlacementDecisionFluentImpl.StatusNestedImpl();
  }
  public PlacementDecisionFluentImpl.StatusNested<A> withNewStatusLike(PlacementDecisionStatus item) {
    return new PlacementDecisionFluentImpl.StatusNestedImpl(item);
  }
  public PlacementDecisionFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public PlacementDecisionFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new PlacementDecisionStatusBuilder().build());
  }
  public PlacementDecisionFluentImpl.StatusNested<A> editOrNewStatusLike(PlacementDecisionStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlacementDecisionFluentImpl that = (PlacementDecisionFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PlacementDecisionFluentImpl.MetadataNested<N>> implements PlacementDecisionFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) PlacementDecisionFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends PlacementDecisionStatusFluentImpl<PlacementDecisionFluentImpl.StatusNested<N>> implements PlacementDecisionFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(PlacementDecisionStatus item) {
      this.builder = new PlacementDecisionStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new PlacementDecisionStatusBuilder(this);
    }
    PlacementDecisionStatusBuilder builder;
    public N and() {
      return (N) PlacementDecisionFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}