package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface ManagedClusterListFluent<A extends ManagedClusterListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(int index,ManagedCluster item);
  public A setToItems(int index,ManagedCluster item);
  public A addToItems(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedCluster... items);
  public A addAllToItems(Collection<ManagedCluster> items);
  public A removeFromItems(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedCluster... items);
  public A removeAllFromItems(Collection<ManagedCluster> items);
  public A removeMatchingFromItems(Predicate<ManagedClusterBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ManagedCluster> getItems();
  public List<ManagedCluster> buildItems();
  public ManagedCluster buildItem(int index);
  public ManagedCluster buildFirstItem();
  public ManagedCluster buildLastItem();
  public ManagedCluster buildMatchingItem(Predicate<ManagedClusterBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ManagedClusterBuilder> predicate);
  public A withItems(List<ManagedCluster> items);
  public A withItems(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedCluster... items);
  public Boolean hasItems();
  public ManagedClusterListFluent.ItemsNested<A> addNewItem();
  public ManagedClusterListFluent.ItemsNested<A> addNewItemLike(ManagedCluster item);
  public ManagedClusterListFluent.ItemsNested<A> setNewItemLike(int index,ManagedCluster item);
  public ManagedClusterListFluent.ItemsNested<A> editItem(int index);
  public ManagedClusterListFluent.ItemsNested<A> editFirstItem();
  public ManagedClusterListFluent.ItemsNested<A> editLastItem();
  public ManagedClusterListFluent.ItemsNested<A> editMatchingItem(Predicate<ManagedClusterBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public interface ItemsNested<N> extends Nested<N>,ManagedClusterFluent<ManagedClusterListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}