package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedClusterSetListBuilder extends ManagedClusterSetListFluentImpl<ManagedClusterSetListBuilder> implements VisitableBuilder<ManagedClusterSetList,ManagedClusterSetListBuilder>{
  public ManagedClusterSetListBuilder() {
    this(false);
  }
  public ManagedClusterSetListBuilder(Boolean validationEnabled) {
    this(new ManagedClusterSetList(), validationEnabled);
  }
  public ManagedClusterSetListBuilder(ManagedClusterSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedClusterSetListBuilder(ManagedClusterSetListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedClusterSetList(), validationEnabled);
  }
  public ManagedClusterSetListBuilder(ManagedClusterSetListFluent<?> fluent,ManagedClusterSetList instance) {
    this(fluent, instance, false);
  }
  public ManagedClusterSetListBuilder(ManagedClusterSetListFluent<?> fluent,ManagedClusterSetList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ManagedClusterSetListBuilder(ManagedClusterSetList instance) {
    this(instance,false);
  }
  public ManagedClusterSetListBuilder(ManagedClusterSetList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ManagedClusterSetListFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedClusterSetList build() {
    ManagedClusterSetList buildable = new ManagedClusterSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}