package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementDecisionStatusBuilder extends PlacementDecisionStatusFluentImpl<PlacementDecisionStatusBuilder> implements VisitableBuilder<PlacementDecisionStatus,PlacementDecisionStatusBuilder>{
  public PlacementDecisionStatusBuilder() {
    this(false);
  }
  public PlacementDecisionStatusBuilder(Boolean validationEnabled) {
    this(new PlacementDecisionStatus(), validationEnabled);
  }
  public PlacementDecisionStatusBuilder(PlacementDecisionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementDecisionStatusBuilder(PlacementDecisionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PlacementDecisionStatus(), validationEnabled);
  }
  public PlacementDecisionStatusBuilder(PlacementDecisionStatusFluent<?> fluent,PlacementDecisionStatus instance) {
    this(fluent, instance, false);
  }
  public PlacementDecisionStatusBuilder(PlacementDecisionStatusFluent<?> fluent,PlacementDecisionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDecisions(instance.getDecisions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlacementDecisionStatusBuilder(PlacementDecisionStatus instance) {
    this(instance,false);
  }
  public PlacementDecisionStatusBuilder(PlacementDecisionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDecisions(instance.getDecisions());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlacementDecisionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PlacementDecisionStatus build() {
    PlacementDecisionStatus buildable = new PlacementDecisionStatus(fluent.getDecisions());
    return buildable;
  }
  
}