package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementDecisionListBuilder extends PlacementDecisionListFluentImpl<PlacementDecisionListBuilder> implements VisitableBuilder<PlacementDecisionList,PlacementDecisionListBuilder>{
  public PlacementDecisionListBuilder() {
    this(false);
  }
  public PlacementDecisionListBuilder(Boolean validationEnabled) {
    this(new PlacementDecisionList(), validationEnabled);
  }
  public PlacementDecisionListBuilder(PlacementDecisionListFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementDecisionListBuilder(PlacementDecisionListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PlacementDecisionList(), validationEnabled);
  }
  public PlacementDecisionListBuilder(PlacementDecisionListFluent<?> fluent,PlacementDecisionList instance) {
    this(fluent, instance, false);
  }
  public PlacementDecisionListBuilder(PlacementDecisionListFluent<?> fluent,PlacementDecisionList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlacementDecisionListBuilder(PlacementDecisionList instance) {
    this(instance,false);
  }
  public PlacementDecisionListBuilder(PlacementDecisionList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlacementDecisionListFluent<?> fluent;
  Boolean validationEnabled;
  public PlacementDecisionList build() {
    PlacementDecisionList buildable = new PlacementDecisionList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}