package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterDecisionBuilder extends ClusterDecisionFluentImpl<ClusterDecisionBuilder> implements VisitableBuilder<ClusterDecision,ClusterDecisionBuilder>{
  public ClusterDecisionBuilder() {
    this(false);
  }
  public ClusterDecisionBuilder(Boolean validationEnabled) {
    this(new ClusterDecision(), validationEnabled);
  }
  public ClusterDecisionBuilder(ClusterDecisionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterDecisionBuilder(ClusterDecisionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterDecision(), validationEnabled);
  }
  public ClusterDecisionBuilder(ClusterDecisionFluent<?> fluent,ClusterDecision instance) {
    this(fluent, instance, false);
  }
  public ClusterDecisionBuilder(ClusterDecisionFluent<?> fluent,ClusterDecision instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClusterName(instance.getClusterName());
      fluent.withReason(instance.getReason());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterDecisionBuilder(ClusterDecision instance) {
    this(instance,false);
  }
  public ClusterDecisionBuilder(ClusterDecision instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClusterName(instance.getClusterName());
      this.withReason(instance.getReason());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterDecisionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterDecision build() {
    ClusterDecision buildable = new ClusterDecision(fluent.getClusterName(),fluent.getReason());
    return buildable;
  }
  
}