package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.util.Collection;
import java.util.Map;

 /**
  * Generated
  */
public interface ManagedClusterStatusFluent<A extends ManagedClusterStatusFluent<A>> extends Fluent<A>{
  public A addToAllocatable(String key,Quantity value);
  public A addToAllocatable(Map<String,Quantity> map);
  public A removeFromAllocatable(String key);
  public A removeFromAllocatable(Map<String,Quantity> map);
  public Map<String,Quantity> getAllocatable();
  public <K,V>A withAllocatable(Map<String,Quantity> allocatable);
  public Boolean hasAllocatable();
  public A addToCapacity(String key,Quantity value);
  public A addToCapacity(Map<String,Quantity> map);
  public A removeFromCapacity(String key);
  public A removeFromCapacity(Map<String,Quantity> map);
  public Map<String,Quantity> getCapacity();
  public <K,V>A withCapacity(Map<String,Quantity> capacity);
  public Boolean hasCapacity();
  public A addToClusterClaims(int index,ManagedClusterClaim item);
  public A setToClusterClaims(int index,ManagedClusterClaim item);
  public A addToClusterClaims(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim... items);
  public A addAllToClusterClaims(Collection<ManagedClusterClaim> items);
  public A removeFromClusterClaims(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim... items);
  public A removeAllFromClusterClaims(Collection<ManagedClusterClaim> items);
  public A removeMatchingFromClusterClaims(Predicate<ManagedClusterClaimBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildClusterClaims instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ManagedClusterClaim> getClusterClaims();
  public List<ManagedClusterClaim> buildClusterClaims();
  public ManagedClusterClaim buildClusterClaim(int index);
  public ManagedClusterClaim buildFirstClusterClaim();
  public ManagedClusterClaim buildLastClusterClaim();
  public ManagedClusterClaim buildMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate);
  public Boolean hasMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate);
  public A withClusterClaims(List<ManagedClusterClaim> clusterClaims);
  public A withClusterClaims(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim... clusterClaims);
  public Boolean hasClusterClaims();
  public A addNewClusterClaim(String name,String value);
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> addNewClusterClaim();
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> addNewClusterClaimLike(ManagedClusterClaim item);
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> setNewClusterClaimLike(int index,ManagedClusterClaim item);
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> editClusterClaim(int index);
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> editFirstClusterClaim();
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> editLastClusterClaim();
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> editMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate);
  public A addToConditions(int index,Condition item);
  public A setToConditions(int index,Condition item);
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items);
  public A addAllToConditions(Collection<Condition> items);
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items);
  public A removeAllFromConditions(Collection<Condition> items);
  public List<Condition> getConditions();
  public Condition getCondition(int index);
  public Condition getFirstCondition();
  public Condition getLastCondition();
  public Condition getMatchingCondition(Predicate<Condition> predicate);
  public Boolean hasMatchingCondition(Predicate<Condition> predicate);
  public A withConditions(List<Condition> conditions);
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions);
  public Boolean hasConditions();
  
  /**
   * This method has been deprecated, please use method buildVersion instead.
   * @return The buildable object.
   */
  @Deprecated
  public ManagedClusterVersion getVersion();
  public ManagedClusterVersion buildVersion();
  public A withVersion(ManagedClusterVersion version);
  public Boolean hasVersion();
  public A withNewVersion(String kubernetes);
  public ManagedClusterStatusFluent.VersionNested<A> withNewVersion();
  public ManagedClusterStatusFluent.VersionNested<A> withNewVersionLike(ManagedClusterVersion item);
  public ManagedClusterStatusFluent.VersionNested<A> editVersion();
  public ManagedClusterStatusFluent.VersionNested<A> editOrNewVersion();
  public ManagedClusterStatusFluent.VersionNested<A> editOrNewVersionLike(ManagedClusterVersion item);
  public interface ClusterClaimsNested<N> extends Nested<N>,ManagedClusterClaimFluent<ManagedClusterStatusFluent.ClusterClaimsNested<N>>{
    public N and();
    public N endClusterClaim();
    
  }
  public interface VersionNested<N> extends Nested<N>,ManagedClusterVersionFluent<ManagedClusterStatusFluent.VersionNested<N>>{
    public N and();
    public N endVersion();
    
  }
  
}