package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedClusterSpecBuilder extends ManagedClusterSpecFluentImpl<ManagedClusterSpecBuilder> implements VisitableBuilder<ManagedClusterSpec,ManagedClusterSpecBuilder>{
  public ManagedClusterSpecBuilder() {
    this(false);
  }
  public ManagedClusterSpecBuilder(Boolean validationEnabled) {
    this(new ManagedClusterSpec(), validationEnabled);
  }
  public ManagedClusterSpecBuilder(ManagedClusterSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedClusterSpecBuilder(ManagedClusterSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedClusterSpec(), validationEnabled);
  }
  public ManagedClusterSpecBuilder(ManagedClusterSpecFluent<?> fluent,ManagedClusterSpec instance) {
    this(fluent, instance, false);
  }
  public ManagedClusterSpecBuilder(ManagedClusterSpecFluent<?> fluent,ManagedClusterSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withHubAcceptsClient(instance.getHubAcceptsClient());
      fluent.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());
      fluent.withManagedClusterClientConfigs(instance.getManagedClusterClientConfigs());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ManagedClusterSpecBuilder(ManagedClusterSpec instance) {
    this(instance,false);
  }
  public ManagedClusterSpecBuilder(ManagedClusterSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withHubAcceptsClient(instance.getHubAcceptsClient());
      this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());
      this.withManagedClusterClientConfigs(instance.getManagedClusterClientConfigs());
    }
    this.validationEnabled = validationEnabled; 
  }
  ManagedClusterSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedClusterSpec build() {
    ManagedClusterSpec buildable = new ManagedClusterSpec(fluent.getHubAcceptsClient(),fluent.getLeaseDurationSeconds(),fluent.getManagedClusterClientConfigs());
    return buildable;
  }
  
}