package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedClusterListBuilder extends ManagedClusterListFluentImpl<ManagedClusterListBuilder> implements VisitableBuilder<ManagedClusterList,ManagedClusterListBuilder>{
  public ManagedClusterListBuilder() {
    this(false);
  }
  public ManagedClusterListBuilder(Boolean validationEnabled) {
    this(new ManagedClusterList(), validationEnabled);
  }
  public ManagedClusterListBuilder(ManagedClusterListFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedClusterListBuilder(ManagedClusterListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedClusterList(), validationEnabled);
  }
  public ManagedClusterListBuilder(ManagedClusterListFluent<?> fluent,ManagedClusterList instance) {
    this(fluent, instance, false);
  }
  public ManagedClusterListBuilder(ManagedClusterListFluent<?> fluent,ManagedClusterList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ManagedClusterListBuilder(ManagedClusterList instance) {
    this(instance,false);
  }
  public ManagedClusterListBuilder(ManagedClusterList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ManagedClusterListFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedClusterList build() {
    ManagedClusterList buildable = new ManagedClusterList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}