package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface ManagedClusterFluent<A extends ManagedClusterFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ManagedClusterFluent.MetadataNested<A> withNewMetadata();
  public ManagedClusterFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ManagedClusterFluent.MetadataNested<A> editMetadata();
  public ManagedClusterFluent.MetadataNested<A> editOrNewMetadata();
  public ManagedClusterFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ManagedClusterSpec getSpec();
  public ManagedClusterSpec buildSpec();
  public A withSpec(ManagedClusterSpec spec);
  public Boolean hasSpec();
  public ManagedClusterFluent.SpecNested<A> withNewSpec();
  public ManagedClusterFluent.SpecNested<A> withNewSpecLike(ManagedClusterSpec item);
  public ManagedClusterFluent.SpecNested<A> editSpec();
  public ManagedClusterFluent.SpecNested<A> editOrNewSpec();
  public ManagedClusterFluent.SpecNested<A> editOrNewSpecLike(ManagedClusterSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ManagedClusterStatus getStatus();
  public ManagedClusterStatus buildStatus();
  public A withStatus(ManagedClusterStatus status);
  public Boolean hasStatus();
  public ManagedClusterFluent.StatusNested<A> withNewStatus();
  public ManagedClusterFluent.StatusNested<A> withNewStatusLike(ManagedClusterStatus item);
  public ManagedClusterFluent.StatusNested<A> editStatus();
  public ManagedClusterFluent.StatusNested<A> editOrNewStatus();
  public ManagedClusterFluent.StatusNested<A> editOrNewStatusLike(ManagedClusterStatus item);
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ManagedClusterFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ManagedClusterSpecFluent<ManagedClusterFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,ManagedClusterStatusFluent<ManagedClusterFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}