package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedClusterVersionBuilder extends ManagedClusterVersionFluentImpl<ManagedClusterVersionBuilder> implements VisitableBuilder<ManagedClusterVersion,ManagedClusterVersionBuilder>{
  public ManagedClusterVersionBuilder() {
    this(false);
  }
  public ManagedClusterVersionBuilder(Boolean validationEnabled) {
    this(new ManagedClusterVersion(), validationEnabled);
  }
  public ManagedClusterVersionBuilder(ManagedClusterVersionFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedClusterVersionBuilder(ManagedClusterVersionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedClusterVersion(), validationEnabled);
  }
  public ManagedClusterVersionBuilder(ManagedClusterVersionFluent<?> fluent,ManagedClusterVersion instance) {
    this(fluent, instance, false);
  }
  public ManagedClusterVersionBuilder(ManagedClusterVersionFluent<?> fluent,ManagedClusterVersion instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKubernetes(instance.getKubernetes()); 
    this.validationEnabled = validationEnabled; 
  }
  public ManagedClusterVersionBuilder(ManagedClusterVersion instance) {
    this(instance,false);
  }
  public ManagedClusterVersionBuilder(ManagedClusterVersion instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withKubernetes(instance.getKubernetes()); 
    this.validationEnabled = validationEnabled; 
  }
  ManagedClusterVersionFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedClusterVersion build() {
    ManagedClusterVersion buildable = new ManagedClusterVersion(fluent.getKubernetes());
    return buildable;
  }
  
}