package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ManagedClusterSetFluentImpl<A extends ManagedClusterSetFluent<A>> extends BaseFluent<A> implements ManagedClusterSetFluent<A>{
  public ManagedClusterSetFluentImpl() {
  }
  public ManagedClusterSetFluentImpl(ManagedClusterSet instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ManagedClusterSetSpecBuilder spec;
  private ManagedClusterSetStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ManagedClusterSetFluent.MetadataNested<A> withNewMetadata() {
    return new ManagedClusterSetFluentImpl.MetadataNestedImpl();
  }
  public ManagedClusterSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ManagedClusterSetFluentImpl.MetadataNestedImpl(item);
  }
  public ManagedClusterSetFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ManagedClusterSetFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ManagedClusterSetFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ManagedClusterSetSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ManagedClusterSetSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ManagedClusterSetSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ManagedClusterSetSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ManagedClusterSetFluent.SpecNested<A> withNewSpec() {
    return new ManagedClusterSetFluentImpl.SpecNestedImpl();
  }
  public ManagedClusterSetFluent.SpecNested<A> withNewSpecLike(ManagedClusterSetSpec item) {
    return new ManagedClusterSetFluentImpl.SpecNestedImpl(item);
  }
  public ManagedClusterSetFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ManagedClusterSetFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ManagedClusterSetSpecBuilder().build());
  }
  public ManagedClusterSetFluent.SpecNested<A> editOrNewSpecLike(ManagedClusterSetSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ManagedClusterSetStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public ManagedClusterSetStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(ManagedClusterSetStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new ManagedClusterSetStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ManagedClusterSetFluent.StatusNested<A> withNewStatus() {
    return new ManagedClusterSetFluentImpl.StatusNestedImpl();
  }
  public ManagedClusterSetFluent.StatusNested<A> withNewStatusLike(ManagedClusterSetStatus item) {
    return new ManagedClusterSetFluentImpl.StatusNestedImpl(item);
  }
  public ManagedClusterSetFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ManagedClusterSetFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new ManagedClusterSetStatusBuilder().build());
  }
  public ManagedClusterSetFluent.StatusNested<A> editOrNewStatusLike(ManagedClusterSetStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ManagedClusterSetFluentImpl that = (ManagedClusterSetFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ManagedClusterSetFluent.MetadataNested<N>> implements ManagedClusterSetFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ManagedClusterSetFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ManagedClusterSetSpecFluentImpl<ManagedClusterSetFluent.SpecNested<N>> implements ManagedClusterSetFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ManagedClusterSetSpec item) {
      this.builder = new ManagedClusterSetSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ManagedClusterSetSpecBuilder(this);
    }
    ManagedClusterSetSpecBuilder builder;
    public N and() {
      return (N) ManagedClusterSetFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends ManagedClusterSetStatusFluentImpl<ManagedClusterSetFluent.StatusNested<N>> implements ManagedClusterSetFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(ManagedClusterSetStatus item) {
      this.builder = new ManagedClusterSetStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new ManagedClusterSetStatusBuilder(this);
    }
    ManagedClusterSetStatusBuilder builder;
    public N and() {
      return (N) ManagedClusterSetFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}