/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterDecision;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterDecisionBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterDecisionFluentImpl;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementDecisionStatus;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementDecisionStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PlacementDecisionStatusFluentImpl<A extends PlacementDecisionStatusFluent<A>>
extends BaseFluent<A>
implements PlacementDecisionStatusFluent<A> {
    private ArrayList<ClusterDecisionBuilder> decisions = new ArrayList();

    public PlacementDecisionStatusFluentImpl() {
    }

    public PlacementDecisionStatusFluentImpl(PlacementDecisionStatus instance) {
        this.withDecisions(instance.getDecisions());
    }

    @Override
    public A addToDecisions(Integer index, ClusterDecision item) {
        if (this.decisions == null) {
            this.decisions = new ArrayList();
        }
        ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);
        this._visitables.get((Object)"decisions").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"decisions").size(), builder);
        this.decisions.add(index >= 0 ? index.intValue() : this.decisions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToDecisions(Integer index, ClusterDecision item) {
        if (this.decisions == null) {
            this.decisions = new ArrayList();
        }
        ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"decisions").size()) {
            this._visitables.get((Object)"decisions").add(builder);
        } else {
            this._visitables.get((Object)"decisions").set(index, builder);
        }
        if (index < 0 || index >= this.decisions.size()) {
            this.decisions.add(builder);
        } else {
            this.decisions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDecisions(ClusterDecision ... items) {
        if (this.decisions == null) {
            this.decisions = new ArrayList();
        }
        for (ClusterDecision item : items) {
            ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);
            this._visitables.get((Object)"decisions").add(builder);
            this.decisions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDecisions(Collection<ClusterDecision> items) {
        if (this.decisions == null) {
            this.decisions = new ArrayList();
        }
        for (ClusterDecision item : items) {
            ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);
            this._visitables.get((Object)"decisions").add(builder);
            this.decisions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDecisions(ClusterDecision ... items) {
        for (ClusterDecision item : items) {
            ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);
            this._visitables.get((Object)"decisions").remove(builder);
            if (this.decisions == null) continue;
            this.decisions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDecisions(Collection<ClusterDecision> items) {
        for (ClusterDecision item : items) {
            ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);
            this._visitables.get((Object)"decisions").remove(builder);
            if (this.decisions == null) continue;
            this.decisions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromDecisions(Predicate<ClusterDecisionBuilder> predicate) {
        if (this.decisions == null) {
            return (A)this;
        }
        Iterator<ClusterDecisionBuilder> each = this.decisions.iterator();
        List visitables = this._visitables.get((Object)"decisions");
        while (each.hasNext()) {
            ClusterDecisionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterDecision> getDecisions() {
        return this.decisions != null ? PlacementDecisionStatusFluentImpl.build(this.decisions) : null;
    }

    @Override
    public List<ClusterDecision> buildDecisions() {
        return this.decisions != null ? PlacementDecisionStatusFluentImpl.build(this.decisions) : null;
    }

    @Override
    public ClusterDecision buildDecision(Integer index) {
        return this.decisions.get(index).build();
    }

    @Override
    public ClusterDecision buildFirstDecision() {
        return this.decisions.get(0).build();
    }

    @Override
    public ClusterDecision buildLastDecision() {
        return this.decisions.get(this.decisions.size() - 1).build();
    }

    @Override
    public ClusterDecision buildMatchingDecision(Predicate<ClusterDecisionBuilder> predicate) {
        for (ClusterDecisionBuilder item : this.decisions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDecision(Predicate<ClusterDecisionBuilder> predicate) {
        for (ClusterDecisionBuilder item : this.decisions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDecisions(List<ClusterDecision> decisions) {
        if (this.decisions != null) {
            this._visitables.get((Object)"decisions").removeAll(this.decisions);
        }
        if (decisions != null) {
            this.decisions = new ArrayList();
            for (ClusterDecision item : decisions) {
                this.addToDecisions(item);
            }
        } else {
            this.decisions = null;
        }
        return (A)this;
    }

    @Override
    public A withDecisions(ClusterDecision ... decisions) {
        if (this.decisions != null) {
            this.decisions.clear();
        }
        if (decisions != null) {
            for (ClusterDecision item : decisions) {
                this.addToDecisions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDecisions() {
        return this.decisions != null && !this.decisions.isEmpty();
    }

    @Override
    public A addNewDecision(String clusterName, String reason) {
        return this.addToDecisions(new ClusterDecision(clusterName, reason));
    }

    @Override
    public PlacementDecisionStatusFluent.DecisionsNested<A> addNewDecision() {
        return new DecisionsNestedImpl();
    }

    @Override
    public PlacementDecisionStatusFluent.DecisionsNested<A> addNewDecisionLike(ClusterDecision item) {
        return new DecisionsNestedImpl(-1, item);
    }

    @Override
    public PlacementDecisionStatusFluent.DecisionsNested<A> setNewDecisionLike(Integer index, ClusterDecision item) {
        return new DecisionsNestedImpl(index, item);
    }

    @Override
    public PlacementDecisionStatusFluent.DecisionsNested<A> editDecision(Integer index) {
        if (this.decisions.size() <= index) {
            throw new RuntimeException("Can't edit decisions. Index exceeds size.");
        }
        return this.setNewDecisionLike(index, this.buildDecision(index));
    }

    @Override
    public PlacementDecisionStatusFluent.DecisionsNested<A> editFirstDecision() {
        if (this.decisions.size() == 0) {
            throw new RuntimeException("Can't edit first decisions. The list is empty.");
        }
        return this.setNewDecisionLike(0, this.buildDecision(0));
    }

    @Override
    public PlacementDecisionStatusFluent.DecisionsNested<A> editLastDecision() {
        int index = this.decisions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last decisions. The list is empty.");
        }
        return this.setNewDecisionLike(index, this.buildDecision(index));
    }

    @Override
    public PlacementDecisionStatusFluent.DecisionsNested<A> editMatchingDecision(Predicate<ClusterDecisionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.decisions.size(); ++i) {
            if (!predicate.test(this.decisions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching decisions. No match found.");
        }
        return this.setNewDecisionLike(index, this.buildDecision(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlacementDecisionStatusFluentImpl that = (PlacementDecisionStatusFluentImpl)o;
        return !(this.decisions != null ? !this.decisions.equals(that.decisions) : that.decisions != null);
    }

    public int hashCode() {
        return Objects.hash(this.decisions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.decisions != null && !this.decisions.isEmpty()) {
            sb.append("decisions:");
            sb.append(this.decisions);
        }
        sb.append("}");
        return sb.toString();
    }

    class DecisionsNestedImpl<N>
    extends ClusterDecisionFluentImpl<PlacementDecisionStatusFluent.DecisionsNested<N>>
    implements PlacementDecisionStatusFluent.DecisionsNested<N>,
    Nested<N> {
        ClusterDecisionBuilder builder;
        Integer index;

        DecisionsNestedImpl(Integer index, ClusterDecision item) {
            this.index = index;
            this.builder = new ClusterDecisionBuilder(this, item);
        }

        DecisionsNestedImpl() {
            this.index = -1;
            this.builder = new ClusterDecisionBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlacementDecisionStatusFluentImpl.this.setToDecisions(this.index, this.builder.build());
        }

        @Override
        public N endDecision() {
            return this.and();
        }
    }
}

