package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ManagedClusterSetBindingFluentImpl<A extends ManagedClusterSetBindingFluent<A>> extends BaseFluent<A> implements ManagedClusterSetBindingFluent<A>{
  public ManagedClusterSetBindingFluentImpl() {
  }
  public ManagedClusterSetBindingFluentImpl(ManagedClusterSetBinding instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ManagedClusterSetBindingSpecBuilder spec;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ManagedClusterSetBindingFluent.MetadataNested<A> withNewMetadata() {
    return new ManagedClusterSetBindingFluentImpl.MetadataNestedImpl();
  }
  public ManagedClusterSetBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ManagedClusterSetBindingFluentImpl.MetadataNestedImpl(item);
  }
  public ManagedClusterSetBindingFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ManagedClusterSetBindingFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ManagedClusterSetBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ManagedClusterSetBindingSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ManagedClusterSetBindingSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ManagedClusterSetBindingSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ManagedClusterSetBindingSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public A withNewSpec(String clusterSet) {
    return (A)withSpec(new ManagedClusterSetBindingSpec(clusterSet));
  }
  public ManagedClusterSetBindingFluent.SpecNested<A> withNewSpec() {
    return new ManagedClusterSetBindingFluentImpl.SpecNestedImpl();
  }
  public ManagedClusterSetBindingFluent.SpecNested<A> withNewSpecLike(ManagedClusterSetBindingSpec item) {
    return new ManagedClusterSetBindingFluentImpl.SpecNestedImpl(item);
  }
  public ManagedClusterSetBindingFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ManagedClusterSetBindingFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ManagedClusterSetBindingSpecBuilder().build());
  }
  public ManagedClusterSetBindingFluent.SpecNested<A> editOrNewSpecLike(ManagedClusterSetBindingSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ManagedClusterSetBindingFluentImpl that = (ManagedClusterSetBindingFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ManagedClusterSetBindingFluent.MetadataNested<N>> implements ManagedClusterSetBindingFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ManagedClusterSetBindingFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ManagedClusterSetBindingSpecFluentImpl<ManagedClusterSetBindingFluent.SpecNested<N>> implements ManagedClusterSetBindingFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ManagedClusterSetBindingSpec item) {
      this.builder = new ManagedClusterSetBindingSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ManagedClusterSetBindingSpecBuilder(this);
    }
    ManagedClusterSetBindingSpecBuilder builder;
    public N and() {
      return (N) ManagedClusterSetBindingFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  
}