package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementSpecBuilder extends PlacementSpecFluentImpl<PlacementSpecBuilder> implements VisitableBuilder<PlacementSpec,PlacementSpecBuilder>{
  public PlacementSpecBuilder() {
    this(false);
  }
  public PlacementSpecBuilder(Boolean validationEnabled) {
    this(new PlacementSpec(), validationEnabled);
  }
  public PlacementSpecBuilder(PlacementSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementSpecBuilder(PlacementSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PlacementSpec(), validationEnabled);
  }
  public PlacementSpecBuilder(PlacementSpecFluent<?> fluent,PlacementSpec instance) {
    this(fluent, instance, false);
  }
  public PlacementSpecBuilder(PlacementSpecFluent<?> fluent,PlacementSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterSets(instance.getClusterSets()); 
    fluent.withNumberOfClusters(instance.getNumberOfClusters()); 
    fluent.withPredicates(instance.getPredicates()); 
    fluent.withPrioritizerPolicy(instance.getPrioritizerPolicy()); 
    this.validationEnabled = validationEnabled; 
  }
  public PlacementSpecBuilder(PlacementSpec instance) {
    this(instance,false);
  }
  public PlacementSpecBuilder(PlacementSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterSets(instance.getClusterSets()); 
    this.withNumberOfClusters(instance.getNumberOfClusters()); 
    this.withPredicates(instance.getPredicates()); 
    this.withPrioritizerPolicy(instance.getPrioritizerPolicy()); 
    this.validationEnabled = validationEnabled; 
  }
  PlacementSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PlacementSpec build() {
    PlacementSpec buildable = new PlacementSpec(fluent.getClusterSets(),fluent.getNumberOfClusters(),fluent.getPredicates(),fluent.getPrioritizerPolicy());
    return buildable;
  }
  
}