package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterClaimSelectorFluentImpl<A extends ClusterClaimSelectorFluent<A>> extends BaseFluent<A> implements ClusterClaimSelectorFluent<A>{
  public ClusterClaimSelectorFluentImpl() {
  }
  public ClusterClaimSelectorFluentImpl(ClusterClaimSelector instance) {
    this.withMatchExpressions(instance.getMatchExpressions()); 
  }
  private List<LabelSelectorRequirement> matchExpressions = new ArrayList<LabelSelectorRequirement>();
  public A addToMatchExpressions(Integer index,LabelSelectorRequirement item) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<LabelSelectorRequirement>();}
    this.matchExpressions.add(index, item);
    return (A)this;
  }
  public A setToMatchExpressions(Integer index,LabelSelectorRequirement item) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<LabelSelectorRequirement>();}
    this.matchExpressions.set(index, item); return (A)this;
  }
  public A addToMatchExpressions(io.fabric8.kubernetes.api.model.LabelSelectorRequirement... items) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<LabelSelectorRequirement>();}
    for (LabelSelectorRequirement item : items) {this.matchExpressions.add(item);} return (A)this;
  }
  public A addAllToMatchExpressions(Collection<LabelSelectorRequirement> items) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<LabelSelectorRequirement>();}
    for (LabelSelectorRequirement item : items) {this.matchExpressions.add(item);} return (A)this;
  }
  public A removeFromMatchExpressions(io.fabric8.kubernetes.api.model.LabelSelectorRequirement... items) {
    for (LabelSelectorRequirement item : items) {if (this.matchExpressions!= null){ this.matchExpressions.remove(item);}} return (A)this;
  }
  public A removeAllFromMatchExpressions(Collection<LabelSelectorRequirement> items) {
    for (LabelSelectorRequirement item : items) {if (this.matchExpressions!= null){ this.matchExpressions.remove(item);}} return (A)this;
  }
  public List<LabelSelectorRequirement> getMatchExpressions() {
    return this.matchExpressions;
  }
  public LabelSelectorRequirement getMatchExpression(Integer index) {
    return this.matchExpressions.get(index);
  }
  public LabelSelectorRequirement getFirstMatchExpression() {
    return this.matchExpressions.get(0);
  }
  public LabelSelectorRequirement getLastMatchExpression() {
    return this.matchExpressions.get(matchExpressions.size() - 1);
  }
  public LabelSelectorRequirement getMatchingMatchExpression(Predicate<LabelSelectorRequirement> predicate) {
    for (LabelSelectorRequirement item: matchExpressions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingMatchExpression(Predicate<LabelSelectorRequirement> predicate) {
    for (LabelSelectorRequirement item: matchExpressions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatchExpressions(List<LabelSelectorRequirement> matchExpressions) {
    if (matchExpressions != null) {this.matchExpressions = new ArrayList(); for (LabelSelectorRequirement item : matchExpressions){this.addToMatchExpressions(item);}} else { this.matchExpressions = null;} return (A) this;
  }
  public A withMatchExpressions(io.fabric8.kubernetes.api.model.LabelSelectorRequirement... matchExpressions) {
    if (this.matchExpressions != null) {this.matchExpressions.clear();}
    if (matchExpressions != null) {for (LabelSelectorRequirement item :matchExpressions){ this.addToMatchExpressions(item);}} return (A) this;
  }
  public Boolean hasMatchExpressions() {
    return matchExpressions != null && !matchExpressions.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterClaimSelectorFluentImpl that = (ClusterClaimSelectorFluentImpl) o;
    if (matchExpressions != null ? !matchExpressions.equals(that.matchExpressions) :that.matchExpressions != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(matchExpressions,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (matchExpressions != null && !matchExpressions.isEmpty()) { sb.append("matchExpressions:"); sb.append(matchExpressions); }
    sb.append("}");
    return sb.toString();
  }
  
}