package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedClusterClaimBuilder extends ManagedClusterClaimFluentImpl<ManagedClusterClaimBuilder> implements VisitableBuilder<ManagedClusterClaim,ManagedClusterClaimBuilder>{
  public ManagedClusterClaimBuilder() {
    this(false);
  }
  public ManagedClusterClaimBuilder(Boolean validationEnabled) {
    this(new ManagedClusterClaim(), validationEnabled);
  }
  public ManagedClusterClaimBuilder(ManagedClusterClaimFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedClusterClaimBuilder(ManagedClusterClaimFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedClusterClaim(), validationEnabled);
  }
  public ManagedClusterClaimBuilder(ManagedClusterClaimFluent<?> fluent,ManagedClusterClaim instance) {
    this(fluent, instance, false);
  }
  public ManagedClusterClaimBuilder(ManagedClusterClaimFluent<?> fluent,ManagedClusterClaim instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public ManagedClusterClaimBuilder(ManagedClusterClaim instance) {
    this(instance,false);
  }
  public ManagedClusterClaimBuilder(ManagedClusterClaim instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  ManagedClusterClaimFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedClusterClaim build() {
    ManagedClusterClaim buildable = new ManagedClusterClaim(fluent.getName(),fluent.getValue());
    return buildable;
  }
  
}