package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedClusterSetBuilder extends ManagedClusterSetFluentImpl<ManagedClusterSetBuilder> implements VisitableBuilder<ManagedClusterSet,ManagedClusterSetBuilder>{
  public ManagedClusterSetBuilder() {
    this(false);
  }
  public ManagedClusterSetBuilder(Boolean validationEnabled) {
    this(new ManagedClusterSet(), validationEnabled);
  }
  public ManagedClusterSetBuilder(ManagedClusterSetFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedClusterSetBuilder(ManagedClusterSetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedClusterSet(), validationEnabled);
  }
  public ManagedClusterSetBuilder(ManagedClusterSetFluent<?> fluent,ManagedClusterSet instance) {
    this(fluent, instance, false);
  }
  public ManagedClusterSetBuilder(ManagedClusterSetFluent<?> fluent,ManagedClusterSet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public ManagedClusterSetBuilder(ManagedClusterSet instance) {
    this(instance,false);
  }
  public ManagedClusterSetBuilder(ManagedClusterSet instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  ManagedClusterSetFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedClusterSet build() {
    ManagedClusterSet buildable = new ManagedClusterSet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}