/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterPredicate;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterPredicateBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterPredicateFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpec;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PrioritizerPolicy;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PrioritizerPolicyBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PrioritizerPolicyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlacementSpecFluent<A extends PlacementSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> clusterSets = new ArrayList<String>();
    private Integer numberOfClusters;
    private ArrayList<ClusterPredicateBuilder> predicates = new ArrayList();
    private PrioritizerPolicyBuilder prioritizerPolicy;
    private Map<String, Object> additionalProperties;

    public PlacementSpecFluent() {
    }

    public PlacementSpecFluent(PlacementSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PlacementSpec instance) {
        PlacementSpec placementSpec = instance = instance != null ? instance : new PlacementSpec();
        if (instance != null) {
            this.withClusterSets(instance.getClusterSets());
            this.withNumberOfClusters(instance.getNumberOfClusters());
            this.withPredicates(instance.getPredicates());
            this.withPrioritizerPolicy(instance.getPrioritizerPolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToClusterSets(int index, String item) {
        if (this.clusterSets == null) {
            this.clusterSets = new ArrayList<String>();
        }
        this.clusterSets.add(index, item);
        return (A)((Object)this);
    }

    public A setToClusterSets(int index, String item) {
        if (this.clusterSets == null) {
            this.clusterSets = new ArrayList<String>();
        }
        this.clusterSets.set(index, item);
        return (A)((Object)this);
    }

    public A addToClusterSets(String ... items) {
        if (this.clusterSets == null) {
            this.clusterSets = new ArrayList<String>();
        }
        for (String item : items) {
            this.clusterSets.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToClusterSets(Collection<String> items) {
        if (this.clusterSets == null) {
            this.clusterSets = new ArrayList<String>();
        }
        for (String item : items) {
            this.clusterSets.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromClusterSets(String ... items) {
        if (this.clusterSets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.clusterSets.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusterSets(Collection<String> items) {
        if (this.clusterSets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.clusterSets.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getClusterSets() {
        return this.clusterSets;
    }

    public String getClusterSet(int index) {
        return this.clusterSets.get(index);
    }

    public String getFirstClusterSet() {
        return this.clusterSets.get(0);
    }

    public String getLastClusterSet() {
        return this.clusterSets.get(this.clusterSets.size() - 1);
    }

    public String getMatchingClusterSet(Predicate<String> predicate) {
        for (String item : this.clusterSets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingClusterSet(Predicate<String> predicate) {
        for (String item : this.clusterSets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusterSets(List<String> clusterSets) {
        if (clusterSets != null) {
            this.clusterSets = new ArrayList<String>();
            for (String item : clusterSets) {
                this.addToClusterSets(item);
            }
        } else {
            this.clusterSets = null;
        }
        return (A)((Object)this);
    }

    public A withClusterSets(String ... clusterSets) {
        if (this.clusterSets != null) {
            this.clusterSets.clear();
            this._visitables.remove((Object)"clusterSets");
        }
        if (clusterSets != null) {
            for (String item : clusterSets) {
                this.addToClusterSets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusterSets() {
        return this.clusterSets != null && !this.clusterSets.isEmpty();
    }

    public Integer getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public A withNumberOfClusters(Integer numberOfClusters) {
        this.numberOfClusters = numberOfClusters;
        return (A)((Object)this);
    }

    public boolean hasNumberOfClusters() {
        return this.numberOfClusters != null;
    }

    public A addToPredicates(int index, ClusterPredicate item) {
        if (this.predicates == null) {
            this.predicates = new ArrayList();
        }
        ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
        if (index < 0 || index >= this.predicates.size()) {
            this._visitables.get((Object)"predicates").add(builder);
            this.predicates.add(builder);
        } else {
            this._visitables.get((Object)"predicates").add(index, builder);
            this.predicates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPredicates(int index, ClusterPredicate item) {
        if (this.predicates == null) {
            this.predicates = new ArrayList();
        }
        ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
        if (index < 0 || index >= this.predicates.size()) {
            this._visitables.get((Object)"predicates").add(builder);
            this.predicates.add(builder);
        } else {
            this._visitables.get((Object)"predicates").set(index, builder);
            this.predicates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPredicates(ClusterPredicate ... items) {
        if (this.predicates == null) {
            this.predicates = new ArrayList();
        }
        for (ClusterPredicate item : items) {
            ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
            this._visitables.get((Object)"predicates").add(builder);
            this.predicates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPredicates(Collection<ClusterPredicate> items) {
        if (this.predicates == null) {
            this.predicates = new ArrayList();
        }
        for (ClusterPredicate item : items) {
            ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
            this._visitables.get((Object)"predicates").add(builder);
            this.predicates.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPredicates(ClusterPredicate ... items) {
        if (this.predicates == null) {
            return (A)((Object)this);
        }
        for (ClusterPredicate item : items) {
            ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
            this._visitables.get((Object)"predicates").remove((Object)builder);
            this.predicates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPredicates(Collection<ClusterPredicate> items) {
        if (this.predicates == null) {
            return (A)((Object)this);
        }
        for (ClusterPredicate item : items) {
            ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
            this._visitables.get((Object)"predicates").remove((Object)builder);
            this.predicates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPredicates(Predicate<ClusterPredicateBuilder> predicate) {
        if (this.predicates == null) {
            return (A)((Object)this);
        }
        Iterator<ClusterPredicateBuilder> each = this.predicates.iterator();
        List visitables = this._visitables.get((Object)"predicates");
        while (each.hasNext()) {
            ClusterPredicateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClusterPredicate> buildPredicates() {
        return this.predicates != null ? PlacementSpecFluent.build(this.predicates) : null;
    }

    public ClusterPredicate buildPredicate(int index) {
        return this.predicates.get(index).build();
    }

    public ClusterPredicate buildFirstPredicate() {
        return this.predicates.get(0).build();
    }

    public ClusterPredicate buildLastPredicate() {
        return this.predicates.get(this.predicates.size() - 1).build();
    }

    public ClusterPredicate buildMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
        for (ClusterPredicateBuilder item : this.predicates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
        for (ClusterPredicateBuilder item : this.predicates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPredicates(List<ClusterPredicate> predicates) {
        if (this.predicates != null) {
            this._visitables.get((Object)"predicates").clear();
        }
        if (predicates != null) {
            this.predicates = new ArrayList();
            for (ClusterPredicate item : predicates) {
                this.addToPredicates(item);
            }
        } else {
            this.predicates = null;
        }
        return (A)((Object)this);
    }

    public A withPredicates(ClusterPredicate ... predicates) {
        if (this.predicates != null) {
            this.predicates.clear();
            this._visitables.remove((Object)"predicates");
        }
        if (predicates != null) {
            for (ClusterPredicate item : predicates) {
                this.addToPredicates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPredicates() {
        return this.predicates != null && !this.predicates.isEmpty();
    }

    public PredicatesNested<A> addNewPredicate() {
        return new PredicatesNested(-1, null);
    }

    public PredicatesNested<A> addNewPredicateLike(ClusterPredicate item) {
        return new PredicatesNested(-1, item);
    }

    public PredicatesNested<A> setNewPredicateLike(int index, ClusterPredicate item) {
        return new PredicatesNested(index, item);
    }

    public PredicatesNested<A> editPredicate(int index) {
        if (this.predicates.size() <= index) {
            throw new RuntimeException("Can't edit predicates. Index exceeds size.");
        }
        return this.setNewPredicateLike(index, this.buildPredicate(index));
    }

    public PredicatesNested<A> editFirstPredicate() {
        if (this.predicates.size() == 0) {
            throw new RuntimeException("Can't edit first predicates. The list is empty.");
        }
        return this.setNewPredicateLike(0, this.buildPredicate(0));
    }

    public PredicatesNested<A> editLastPredicate() {
        int index = this.predicates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last predicates. The list is empty.");
        }
        return this.setNewPredicateLike(index, this.buildPredicate(index));
    }

    public PredicatesNested<A> editMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.predicates.size(); ++i) {
            if (!predicate.test(this.predicates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching predicates. No match found.");
        }
        return this.setNewPredicateLike(index, this.buildPredicate(index));
    }

    public PrioritizerPolicy buildPrioritizerPolicy() {
        return this.prioritizerPolicy != null ? this.prioritizerPolicy.build() : null;
    }

    public A withPrioritizerPolicy(PrioritizerPolicy prioritizerPolicy) {
        this._visitables.remove((Object)"prioritizerPolicy");
        if (prioritizerPolicy != null) {
            this.prioritizerPolicy = new PrioritizerPolicyBuilder(prioritizerPolicy);
            this._visitables.get((Object)"prioritizerPolicy").add(this.prioritizerPolicy);
        } else {
            this.prioritizerPolicy = null;
            this._visitables.get((Object)"prioritizerPolicy").remove((Object)this.prioritizerPolicy);
        }
        return (A)((Object)this);
    }

    public boolean hasPrioritizerPolicy() {
        return this.prioritizerPolicy != null;
    }

    public PrioritizerPolicyNested<A> withNewPrioritizerPolicy() {
        return new PrioritizerPolicyNested(null);
    }

    public PrioritizerPolicyNested<A> withNewPrioritizerPolicyLike(PrioritizerPolicy item) {
        return new PrioritizerPolicyNested(item);
    }

    public PrioritizerPolicyNested<A> editPrioritizerPolicy() {
        return this.withNewPrioritizerPolicyLike(Optional.ofNullable(this.buildPrioritizerPolicy()).orElse(null));
    }

    public PrioritizerPolicyNested<A> editOrNewPrioritizerPolicy() {
        return this.withNewPrioritizerPolicyLike(Optional.ofNullable(this.buildPrioritizerPolicy()).orElse(new PrioritizerPolicyBuilder().build()));
    }

    public PrioritizerPolicyNested<A> editOrNewPrioritizerPolicyLike(PrioritizerPolicy item) {
        return this.withNewPrioritizerPolicyLike(Optional.ofNullable(this.buildPrioritizerPolicy()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlacementSpecFluent that = (PlacementSpecFluent)((Object)o);
        if (!Objects.equals(this.clusterSets, that.clusterSets)) {
            return false;
        }
        if (!Objects.equals(this.numberOfClusters, that.numberOfClusters)) {
            return false;
        }
        if (!Objects.equals(this.predicates, that.predicates)) {
            return false;
        }
        if (!Objects.equals((Object)this.prioritizerPolicy, (Object)that.prioritizerPolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clusterSets, this.numberOfClusters, this.predicates, this.prioritizerPolicy, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterSets != null && !this.clusterSets.isEmpty()) {
            sb.append("clusterSets:");
            sb.append(this.clusterSets + ",");
        }
        if (this.numberOfClusters != null) {
            sb.append("numberOfClusters:");
            sb.append(this.numberOfClusters + ",");
        }
        if (this.predicates != null && !this.predicates.isEmpty()) {
            sb.append("predicates:");
            sb.append(this.predicates + ",");
        }
        if (this.prioritizerPolicy != null) {
            sb.append("prioritizerPolicy:");
            sb.append((Object)((Object)this.prioritizerPolicy) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PrioritizerPolicyNested<N>
    extends PrioritizerPolicyFluent<PrioritizerPolicyNested<N>>
    implements Nested<N> {
        PrioritizerPolicyBuilder builder;

        PrioritizerPolicyNested(PrioritizerPolicy item) {
            this.builder = new PrioritizerPolicyBuilder(this, item);
        }

        public N and() {
            return (N)PlacementSpecFluent.this.withPrioritizerPolicy(this.builder.build());
        }

        public N endPrioritizerPolicy() {
            return this.and();
        }
    }

    public class PredicatesNested<N>
    extends ClusterPredicateFluent<PredicatesNested<N>>
    implements Nested<N> {
        ClusterPredicateBuilder builder;
        int index;

        PredicatesNested(int index, ClusterPredicate item) {
            this.index = index;
            this.builder = new ClusterPredicateBuilder(this, item);
        }

        public N and() {
            return (N)PlacementSpecFluent.this.setToPredicates(this.index, this.builder.build());
        }

        public N endPredicate() {
            return this.and();
        }
    }
}

