/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterDecision;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterDecisionBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterDecisionFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementDecisionStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PlacementDecisionStatusFluent<A extends PlacementDecisionStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ClusterDecisionBuilder> decisions = new ArrayList();
    private Map<String, Object> additionalProperties;

    public PlacementDecisionStatusFluent() {
    }

    public PlacementDecisionStatusFluent(PlacementDecisionStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PlacementDecisionStatus instance) {
        PlacementDecisionStatus placementDecisionStatus = instance = instance != null ? instance : new PlacementDecisionStatus();
        if (instance != null) {
            this.withDecisions(instance.getDecisions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToDecisions(int index, ClusterDecision item) {
        if (this.decisions == null) {
            this.decisions = new ArrayList();
        }
        ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);
        if (index < 0 || index >= this.decisions.size()) {
            this._visitables.get((Object)"decisions").add(builder);
            this.decisions.add(builder);
        } else {
            this._visitables.get((Object)"decisions").add(index, builder);
            this.decisions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDecisions(int index, ClusterDecision item) {
        if (this.decisions == null) {
            this.decisions = new ArrayList();
        }
        ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);
        if (index < 0 || index >= this.decisions.size()) {
            this._visitables.get((Object)"decisions").add(builder);
            this.decisions.add(builder);
        } else {
            this._visitables.get((Object)"decisions").set(index, builder);
            this.decisions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDecisions(ClusterDecision ... items) {
        if (this.decisions == null) {
            this.decisions = new ArrayList();
        }
        for (ClusterDecision item : items) {
            ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);
            this._visitables.get((Object)"decisions").add(builder);
            this.decisions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDecisions(Collection<ClusterDecision> items) {
        if (this.decisions == null) {
            this.decisions = new ArrayList();
        }
        for (ClusterDecision item : items) {
            ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);
            this._visitables.get((Object)"decisions").add(builder);
            this.decisions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDecisions(ClusterDecision ... items) {
        if (this.decisions == null) {
            return (A)((Object)this);
        }
        for (ClusterDecision item : items) {
            ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);
            this._visitables.get((Object)"decisions").remove((Object)builder);
            this.decisions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDecisions(Collection<ClusterDecision> items) {
        if (this.decisions == null) {
            return (A)((Object)this);
        }
        for (ClusterDecision item : items) {
            ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);
            this._visitables.get((Object)"decisions").remove((Object)builder);
            this.decisions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDecisions(Predicate<ClusterDecisionBuilder> predicate) {
        if (this.decisions == null) {
            return (A)((Object)this);
        }
        Iterator<ClusterDecisionBuilder> each = this.decisions.iterator();
        List visitables = this._visitables.get((Object)"decisions");
        while (each.hasNext()) {
            ClusterDecisionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ClusterDecision> buildDecisions() {
        return this.decisions != null ? PlacementDecisionStatusFluent.build(this.decisions) : null;
    }

    public ClusterDecision buildDecision(int index) {
        return this.decisions.get(index).build();
    }

    public ClusterDecision buildFirstDecision() {
        return this.decisions.get(0).build();
    }

    public ClusterDecision buildLastDecision() {
        return this.decisions.get(this.decisions.size() - 1).build();
    }

    public ClusterDecision buildMatchingDecision(Predicate<ClusterDecisionBuilder> predicate) {
        for (ClusterDecisionBuilder item : this.decisions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDecision(Predicate<ClusterDecisionBuilder> predicate) {
        for (ClusterDecisionBuilder item : this.decisions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDecisions(List<ClusterDecision> decisions) {
        if (this.decisions != null) {
            this._visitables.get((Object)"decisions").clear();
        }
        if (decisions != null) {
            this.decisions = new ArrayList();
            for (ClusterDecision item : decisions) {
                this.addToDecisions(item);
            }
        } else {
            this.decisions = null;
        }
        return (A)((Object)this);
    }

    public A withDecisions(ClusterDecision ... decisions) {
        if (this.decisions != null) {
            this.decisions.clear();
            this._visitables.remove((Object)"decisions");
        }
        if (decisions != null) {
            for (ClusterDecision item : decisions) {
                this.addToDecisions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDecisions() {
        return this.decisions != null && !this.decisions.isEmpty();
    }

    public A addNewDecision(String clusterName, String reason) {
        return this.addToDecisions(new ClusterDecision(clusterName, reason));
    }

    public DecisionsNested<A> addNewDecision() {
        return new DecisionsNested(-1, null);
    }

    public DecisionsNested<A> addNewDecisionLike(ClusterDecision item) {
        return new DecisionsNested(-1, item);
    }

    public DecisionsNested<A> setNewDecisionLike(int index, ClusterDecision item) {
        return new DecisionsNested(index, item);
    }

    public DecisionsNested<A> editDecision(int index) {
        if (this.decisions.size() <= index) {
            throw new RuntimeException("Can't edit decisions. Index exceeds size.");
        }
        return this.setNewDecisionLike(index, this.buildDecision(index));
    }

    public DecisionsNested<A> editFirstDecision() {
        if (this.decisions.size() == 0) {
            throw new RuntimeException("Can't edit first decisions. The list is empty.");
        }
        return this.setNewDecisionLike(0, this.buildDecision(0));
    }

    public DecisionsNested<A> editLastDecision() {
        int index = this.decisions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last decisions. The list is empty.");
        }
        return this.setNewDecisionLike(index, this.buildDecision(index));
    }

    public DecisionsNested<A> editMatchingDecision(Predicate<ClusterDecisionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.decisions.size(); ++i) {
            if (!predicate.test(this.decisions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching decisions. No match found.");
        }
        return this.setNewDecisionLike(index, this.buildDecision(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlacementDecisionStatusFluent that = (PlacementDecisionStatusFluent)((Object)o);
        if (!Objects.equals(this.decisions, that.decisions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.decisions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.decisions != null && !this.decisions.isEmpty()) {
            sb.append("decisions:");
            sb.append(this.decisions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DecisionsNested<N>
    extends ClusterDecisionFluent<DecisionsNested<N>>
    implements Nested<N> {
        ClusterDecisionBuilder builder;
        int index;

        DecisionsNested(int index, ClusterDecision item) {
            this.index = index;
            this.builder = new ClusterDecisionBuilder(this, item);
        }

        public N and() {
            return (N)PlacementDecisionStatusFluent.this.setToDecisions(this.index, this.builder.build());
        }

        public N endDecision() {
            return this.and();
        }
    }
}

