package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterSelectorFluent<A extends ClusterSelectorFluent<A>> extends BaseFluent<A>{
  public ClusterSelectorFluent() {
  }
  
  public ClusterSelectorFluent(ClusterSelector instance) {
    this.copyInstance(instance);
  }
  private ClusterClaimSelectorBuilder claimSelector;
  private LabelSelectorBuilder labelSelector;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterSelector instance) {
    instance = (instance != null ? instance : new ClusterSelector());
    if (instance != null) {
          this.withClaimSelector(instance.getClaimSelector());
          this.withLabelSelector(instance.getLabelSelector());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ClusterClaimSelector buildClaimSelector() {
    return this.claimSelector != null ? this.claimSelector.build() : null;
  }
  
  public A withClaimSelector(ClusterClaimSelector claimSelector) {
    this._visitables.remove("claimSelector");
    if (claimSelector != null) {
        this.claimSelector = new ClusterClaimSelectorBuilder(claimSelector);
        this._visitables.get("claimSelector").add(this.claimSelector);
    } else {
        this.claimSelector = null;
        this._visitables.get("claimSelector").remove(this.claimSelector);
    }
    return (A) this;
  }
  
  public boolean hasClaimSelector() {
    return this.claimSelector != null;
  }
  
  public ClaimSelectorNested<A> withNewClaimSelector() {
    return new ClaimSelectorNested(null);
  }
  
  public ClaimSelectorNested<A> withNewClaimSelectorLike(ClusterClaimSelector item) {
    return new ClaimSelectorNested(item);
  }
  
  public ClaimSelectorNested<A> editClaimSelector() {
    return withNewClaimSelectorLike(java.util.Optional.ofNullable(buildClaimSelector()).orElse(null));
  }
  
  public ClaimSelectorNested<A> editOrNewClaimSelector() {
    return withNewClaimSelectorLike(java.util.Optional.ofNullable(buildClaimSelector()).orElse(new ClusterClaimSelectorBuilder().build()));
  }
  
  public ClaimSelectorNested<A> editOrNewClaimSelectorLike(ClusterClaimSelector item) {
    return withNewClaimSelectorLike(java.util.Optional.ofNullable(buildClaimSelector()).orElse(item));
  }
  
  public LabelSelector buildLabelSelector() {
    return this.labelSelector != null ? this.labelSelector.build() : null;
  }
  
  public A withLabelSelector(LabelSelector labelSelector) {
    this._visitables.remove("labelSelector");
    if (labelSelector != null) {
        this.labelSelector = new LabelSelectorBuilder(labelSelector);
        this._visitables.get("labelSelector").add(this.labelSelector);
    } else {
        this.labelSelector = null;
        this._visitables.get("labelSelector").remove(this.labelSelector);
    }
    return (A) this;
  }
  
  public boolean hasLabelSelector() {
    return this.labelSelector != null;
  }
  
  public LabelSelectorNested<A> withNewLabelSelector() {
    return new LabelSelectorNested(null);
  }
  
  public LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
    return new LabelSelectorNested(item);
  }
  
  public LabelSelectorNested<A> editLabelSelector() {
    return withNewLabelSelectorLike(java.util.Optional.ofNullable(buildLabelSelector()).orElse(null));
  }
  
  public LabelSelectorNested<A> editOrNewLabelSelector() {
    return withNewLabelSelectorLike(java.util.Optional.ofNullable(buildLabelSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
    return withNewLabelSelectorLike(java.util.Optional.ofNullable(buildLabelSelector()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterSelectorFluent that = (ClusterSelectorFluent) o;
    if (!java.util.Objects.equals(claimSelector, that.claimSelector)) return false;
    if (!java.util.Objects.equals(labelSelector, that.labelSelector)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(claimSelector,  labelSelector,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (claimSelector != null) { sb.append("claimSelector:"); sb.append(claimSelector + ","); }
    if (labelSelector != null) { sb.append("labelSelector:"); sb.append(labelSelector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClaimSelectorNested<N> extends ClusterClaimSelectorFluent<ClaimSelectorNested<N>> implements Nested<N>{
    ClaimSelectorNested(ClusterClaimSelector item) {
      this.builder = new ClusterClaimSelectorBuilder(this, item);
    }
    ClusterClaimSelectorBuilder builder;
    
    public N and() {
      return (N) ClusterSelectorFluent.this.withClaimSelector(builder.build());
    }
    
    public N endClaimSelector() {
      return and();
    }
    
  
  }
  public class LabelSelectorNested<N> extends LabelSelectorFluent<LabelSelectorNested<N>> implements Nested<N>{
    LabelSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ClusterSelectorFluent.this.withLabelSelector(builder.build());
    }
    
    public N endLabelSelector() {
      return and();
    }
    
  
  }

}