package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterSelectorBuilder extends ClusterSelectorFluent<ClusterSelectorBuilder> implements VisitableBuilder<ClusterSelector,ClusterSelectorBuilder>{
  public ClusterSelectorBuilder() {
    this(new ClusterSelector());
  }
  
  public ClusterSelectorBuilder(ClusterSelectorFluent<?> fluent) {
    this(fluent, new ClusterSelector());
  }
  
  public ClusterSelectorBuilder(ClusterSelectorFluent<?> fluent,ClusterSelector instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterSelectorBuilder(ClusterSelector instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterSelectorFluent<?> fluent;
  
  public ClusterSelector build() {
    ClusterSelector buildable = new ClusterSelector(fluent.buildClaimSelector(),fluent.buildLabelSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}