package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ManagedClusterSpecBuilder extends ManagedClusterSpecFluent<ManagedClusterSpecBuilder> implements VisitableBuilder<ManagedClusterSpec,ManagedClusterSpecBuilder>{
  public ManagedClusterSpecBuilder() {
    this(new ManagedClusterSpec());
  }
  
  public ManagedClusterSpecBuilder(ManagedClusterSpecFluent<?> fluent) {
    this(fluent, new ManagedClusterSpec());
  }
  
  public ManagedClusterSpecBuilder(ManagedClusterSpecFluent<?> fluent,ManagedClusterSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ManagedClusterSpecBuilder(ManagedClusterSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ManagedClusterSpecFluent<?> fluent;
  
  public ManagedClusterSpec build() {
    ManagedClusterSpec buildable = new ManagedClusterSpec(fluent.getHubAcceptsClient(),fluent.getLeaseDurationSeconds(),fluent.buildManagedClusterClientConfigs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}