package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PlacementSpecBuilder extends PlacementSpecFluent<PlacementSpecBuilder> implements VisitableBuilder<PlacementSpec,PlacementSpecBuilder>{
  public PlacementSpecBuilder() {
    this(new PlacementSpec());
  }
  
  public PlacementSpecBuilder(PlacementSpecFluent<?> fluent) {
    this(fluent, new PlacementSpec());
  }
  
  public PlacementSpecBuilder(PlacementSpecFluent<?> fluent,PlacementSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PlacementSpecBuilder(PlacementSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PlacementSpecFluent<?> fluent;
  
  public PlacementSpec build() {
    PlacementSpec buildable = new PlacementSpec(fluent.getClusterSets(),fluent.getNumberOfClusters(),fluent.buildPredicates(),fluent.buildPrioritizerPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}