package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterDecisionBuilder extends ClusterDecisionFluent<ClusterDecisionBuilder> implements VisitableBuilder<ClusterDecision,ClusterDecisionBuilder>{
  public ClusterDecisionBuilder() {
    this(new ClusterDecision());
  }
  
  public ClusterDecisionBuilder(ClusterDecisionFluent<?> fluent) {
    this(fluent, new ClusterDecision());
  }
  
  public ClusterDecisionBuilder(ClusterDecisionFluent<?> fluent,ClusterDecision instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterDecisionBuilder(ClusterDecision instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterDecisionFluent<?> fluent;
  
  public ClusterDecision build() {
    ClusterDecision buildable = new ClusterDecision(fluent.getClusterName(),fluent.getReason());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}