package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedClusterSetBindingBuilder extends ManagedClusterSetBindingFluentImpl<ManagedClusterSetBindingBuilder> implements VisitableBuilder<ManagedClusterSetBinding,ManagedClusterSetBindingBuilder>{
  public ManagedClusterSetBindingBuilder() {
    this(false);
  }
  public ManagedClusterSetBindingBuilder(Boolean validationEnabled) {
    this(new ManagedClusterSetBinding(), validationEnabled);
  }
  public ManagedClusterSetBindingBuilder(ManagedClusterSetBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedClusterSetBindingBuilder(ManagedClusterSetBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedClusterSetBinding(), validationEnabled);
  }
  public ManagedClusterSetBindingBuilder(ManagedClusterSetBindingFluent<?> fluent,ManagedClusterSetBinding instance) {
    this(fluent, instance, false);
  }
  public ManagedClusterSetBindingBuilder(ManagedClusterSetBindingFluent<?> fluent,ManagedClusterSetBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    this.validationEnabled = validationEnabled; 
  }
  public ManagedClusterSetBindingBuilder(ManagedClusterSetBinding instance) {
    this(instance,false);
  }
  public ManagedClusterSetBindingBuilder(ManagedClusterSetBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.validationEnabled = validationEnabled; 
  }
  ManagedClusterSetBindingFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedClusterSetBinding build() {
    ManagedClusterSetBinding buildable = new ManagedClusterSetBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    return buildable;
  }
  
}