
package io.fabric8.openclustermanagement.api.model.cluster.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "hubAcceptsClient",
    "leaseDurationSeconds",
    "managedClusterClientConfigs"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Setter
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class ManagedClusterSpec implements KubernetesResource
{

    @JsonProperty("hubAcceptsClient")
    private Boolean hubAcceptsClient;
    @JsonProperty("leaseDurationSeconds")
    private Integer leaseDurationSeconds;
    @JsonProperty("managedClusterClientConfigs")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<ClientConfig> managedClusterClientConfigs = new ArrayList<ClientConfig>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ManagedClusterSpec() {
    }

    /**
     * 
     * @param hubAcceptsClient
     * @param leaseDurationSeconds
     * @param managedClusterClientConfigs
     */
    public ManagedClusterSpec(Boolean hubAcceptsClient, Integer leaseDurationSeconds, List<ClientConfig> managedClusterClientConfigs) {
        super();
        this.hubAcceptsClient = hubAcceptsClient;
        this.leaseDurationSeconds = leaseDurationSeconds;
        this.managedClusterClientConfigs = managedClusterClientConfigs;
    }

    @JsonProperty("hubAcceptsClient")
    public Boolean getHubAcceptsClient() {
        return hubAcceptsClient;
    }

    @JsonProperty("hubAcceptsClient")
    public void setHubAcceptsClient(Boolean hubAcceptsClient) {
        this.hubAcceptsClient = hubAcceptsClient;
    }

    @JsonProperty("leaseDurationSeconds")
    public Integer getLeaseDurationSeconds() {
        return leaseDurationSeconds;
    }

    @JsonProperty("leaseDurationSeconds")
    public void setLeaseDurationSeconds(Integer leaseDurationSeconds) {
        this.leaseDurationSeconds = leaseDurationSeconds;
    }

    @JsonProperty("managedClusterClientConfigs")
    public List<ClientConfig> getManagedClusterClientConfigs() {
        return managedClusterClientConfigs;
    }

    @JsonProperty("managedClusterClientConfigs")
    public void setManagedClusterClientConfigs(List<ClientConfig> managedClusterClientConfigs) {
        this.managedClusterClientConfigs = managedClusterClientConfigs;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
