/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimFluentImpl;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatus;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersion;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersionBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ManagedClusterStatusFluentImpl<A extends ManagedClusterStatusFluent<A>>
extends BaseFluent<A>
implements ManagedClusterStatusFluent<A> {
    private Map<String, Quantity> allocatable;
    private Map<String, Quantity> capacity;
    private List<ManagedClusterClaimBuilder> clusterClaims;
    private List<Condition> conditions;
    private ManagedClusterVersionBuilder version;

    public ManagedClusterStatusFluentImpl() {
    }

    public ManagedClusterStatusFluentImpl(ManagedClusterStatus instance) {
        this.withAllocatable(instance.getAllocatable());
        this.withCapacity(instance.getCapacity());
        this.withClusterClaims(instance.getClusterClaims());
        this.withConditions(instance.getConditions());
        this.withVersion(instance.getVersion());
    }

    @Override
    public A addToAllocatable(String key, Quantity value) {
        if (this.allocatable == null && key != null && value != null) {
            this.allocatable = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.allocatable.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAllocatable(Map<String, Quantity> map) {
        if (this.allocatable == null && map != null) {
            this.allocatable = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.allocatable.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllocatable(String key) {
        if (this.allocatable == null) {
            return (A)this;
        }
        if (key != null && this.allocatable != null) {
            this.allocatable.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllocatable(Map<String, Quantity> map) {
        if (this.allocatable == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.allocatable == null) continue;
                this.allocatable.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getAllocatable() {
        return this.allocatable;
    }

    @Override
    public <K, V> A withAllocatable(Map<String, Quantity> allocatable) {
        this.allocatable = allocatable == null ? null : new LinkedHashMap<String, Quantity>(allocatable);
        return (A)this;
    }

    @Override
    public Boolean hasAllocatable() {
        return this.allocatable != null;
    }

    @Override
    public A addToCapacity(String key, Quantity value) {
        if (this.capacity == null && key != null && value != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToCapacity(Map<String, Quantity> map) {
        if (this.capacity == null && map != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(String key) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (key != null && this.capacity != null) {
            this.capacity.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(Map<String, Quantity> map) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capacity == null) continue;
                this.capacity.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    @Override
    public <K, V> A withCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity == null ? null : new LinkedHashMap<String, Quantity>(capacity);
        return (A)this;
    }

    @Override
    public Boolean hasCapacity() {
        return this.capacity != null;
    }

    @Override
    public A addToClusterClaims(Integer index, ManagedClusterClaim item) {
        if (this.clusterClaims == null) {
            this.clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();
        }
        ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
        this._visitables.get((Object)"clusterClaims").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"clusterClaims").size(), builder);
        this.clusterClaims.add(index >= 0 ? index.intValue() : this.clusterClaims.size(), builder);
        return (A)this;
    }

    @Override
    public A setToClusterClaims(Integer index, ManagedClusterClaim item) {
        if (this.clusterClaims == null) {
            this.clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();
        }
        ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"clusterClaims").size()) {
            this._visitables.get((Object)"clusterClaims").add(builder);
        } else {
            this._visitables.get((Object)"clusterClaims").set(index, builder);
        }
        if (index < 0 || index >= this.clusterClaims.size()) {
            this.clusterClaims.add(builder);
        } else {
            this.clusterClaims.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToClusterClaims(ManagedClusterClaim ... items) {
        if (this.clusterClaims == null) {
            this.clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();
        }
        for (ManagedClusterClaim item : items) {
            ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
            this._visitables.get((Object)"clusterClaims").add(builder);
            this.clusterClaims.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToClusterClaims(Collection<ManagedClusterClaim> items) {
        if (this.clusterClaims == null) {
            this.clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();
        }
        for (ManagedClusterClaim item : items) {
            ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
            this._visitables.get((Object)"clusterClaims").add(builder);
            this.clusterClaims.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusterClaims(ManagedClusterClaim ... items) {
        for (ManagedClusterClaim item : items) {
            ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
            this._visitables.get((Object)"clusterClaims").remove(builder);
            if (this.clusterClaims == null) continue;
            this.clusterClaims.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClusterClaims(Collection<ManagedClusterClaim> items) {
        for (ManagedClusterClaim item : items) {
            ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
            this._visitables.get((Object)"clusterClaims").remove(builder);
            if (this.clusterClaims == null) continue;
            this.clusterClaims.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromClusterClaims(Predicate<ManagedClusterClaimBuilder> predicate) {
        if (this.clusterClaims == null) {
            return (A)this;
        }
        Iterator<ManagedClusterClaimBuilder> each = this.clusterClaims.iterator();
        List visitables = this._visitables.get((Object)"clusterClaims");
        while (each.hasNext()) {
            ManagedClusterClaimBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ManagedClusterClaim> getClusterClaims() {
        return ManagedClusterStatusFluentImpl.build(this.clusterClaims);
    }

    @Override
    public List<ManagedClusterClaim> buildClusterClaims() {
        return ManagedClusterStatusFluentImpl.build(this.clusterClaims);
    }

    @Override
    public ManagedClusterClaim buildClusterClaim(Integer index) {
        return this.clusterClaims.get(index).build();
    }

    @Override
    public ManagedClusterClaim buildFirstClusterClaim() {
        return this.clusterClaims.get(0).build();
    }

    @Override
    public ManagedClusterClaim buildLastClusterClaim() {
        return this.clusterClaims.get(this.clusterClaims.size() - 1).build();
    }

    @Override
    public ManagedClusterClaim buildMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate) {
        for (ManagedClusterClaimBuilder item : this.clusterClaims) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate) {
        for (ManagedClusterClaimBuilder item : this.clusterClaims) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClusterClaims(List<ManagedClusterClaim> clusterClaims) {
        if (this.clusterClaims != null) {
            this._visitables.get((Object)"clusterClaims").removeAll(this.clusterClaims);
        }
        if (clusterClaims != null) {
            this.clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();
            for (ManagedClusterClaim item : clusterClaims) {
                this.addToClusterClaims(item);
            }
        } else {
            this.clusterClaims = null;
        }
        return (A)this;
    }

    @Override
    public A withClusterClaims(ManagedClusterClaim ... clusterClaims) {
        if (this.clusterClaims != null) {
            this.clusterClaims.clear();
        }
        if (clusterClaims != null) {
            for (ManagedClusterClaim item : clusterClaims) {
                this.addToClusterClaims(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterClaims() {
        return this.clusterClaims != null && !this.clusterClaims.isEmpty();
    }

    @Override
    public A addNewClusterClaim(String name, String value) {
        return this.addToClusterClaims(new ManagedClusterClaim(name, value));
    }

    @Override
    public ManagedClusterStatusFluent.ClusterClaimsNested<A> addNewClusterClaim() {
        return new ClusterClaimsNestedImpl();
    }

    @Override
    public ManagedClusterStatusFluent.ClusterClaimsNested<A> addNewClusterClaimLike(ManagedClusterClaim item) {
        return new ClusterClaimsNestedImpl(-1, item);
    }

    @Override
    public ManagedClusterStatusFluent.ClusterClaimsNested<A> setNewClusterClaimLike(Integer index, ManagedClusterClaim item) {
        return new ClusterClaimsNestedImpl(index, item);
    }

    @Override
    public ManagedClusterStatusFluent.ClusterClaimsNested<A> editClusterClaim(Integer index) {
        if (this.clusterClaims.size() <= index) {
            throw new RuntimeException("Can't edit clusterClaims. Index exceeds size.");
        }
        return this.setNewClusterClaimLike(index, this.buildClusterClaim(index));
    }

    @Override
    public ManagedClusterStatusFluent.ClusterClaimsNested<A> editFirstClusterClaim() {
        if (this.clusterClaims.size() == 0) {
            throw new RuntimeException("Can't edit first clusterClaims. The list is empty.");
        }
        return this.setNewClusterClaimLike(0, this.buildClusterClaim(0));
    }

    @Override
    public ManagedClusterStatusFluent.ClusterClaimsNested<A> editLastClusterClaim() {
        int index = this.clusterClaims.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterClaims. The list is empty.");
        }
        return this.setNewClusterClaimLike(index, this.buildClusterClaim(index));
    }

    @Override
    public ManagedClusterStatusFluent.ClusterClaimsNested<A> editMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterClaims.size(); ++i) {
            if (!predicate.test(this.clusterClaims.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterClaims. No match found.");
        }
        return this.setNewClusterClaimLike(index, this.buildClusterClaim(index));
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(Integer index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    @Deprecated
    public ManagedClusterVersion getVersion() {
        return this.version != null ? this.version.build() : null;
    }

    @Override
    public ManagedClusterVersion buildVersion() {
        return this.version != null ? this.version.build() : null;
    }

    @Override
    public A withVersion(ManagedClusterVersion version) {
        this._visitables.get((Object)"version").remove(this.version);
        if (version != null) {
            this.version = new ManagedClusterVersionBuilder(version);
            this._visitables.get((Object)"version").add(this.version);
        }
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public A withNewVersion(String kubernetes) {
        return this.withVersion(new ManagedClusterVersion(kubernetes));
    }

    @Override
    public ManagedClusterStatusFluent.VersionNested<A> withNewVersion() {
        return new VersionNestedImpl();
    }

    @Override
    public ManagedClusterStatusFluent.VersionNested<A> withNewVersionLike(ManagedClusterVersion item) {
        return new VersionNestedImpl(item);
    }

    @Override
    public ManagedClusterStatusFluent.VersionNested<A> editVersion() {
        return this.withNewVersionLike(this.getVersion());
    }

    @Override
    public ManagedClusterStatusFluent.VersionNested<A> editOrNewVersion() {
        return this.withNewVersionLike(this.getVersion() != null ? this.getVersion() : new ManagedClusterVersionBuilder().build());
    }

    @Override
    public ManagedClusterStatusFluent.VersionNested<A> editOrNewVersionLike(ManagedClusterVersion item) {
        return this.withNewVersionLike(this.getVersion() != null ? this.getVersion() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedClusterStatusFluentImpl that = (ManagedClusterStatusFluentImpl)o;
        if (this.allocatable != null ? !this.allocatable.equals(that.allocatable) : that.allocatable != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.clusterClaims != null ? !this.clusterClaims.equals(that.clusterClaims) : that.clusterClaims != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return Objects.hash(this.allocatable, this.capacity, this.clusterClaims, this.conditions, this.version, super.hashCode());
    }

    public class VersionNestedImpl<N>
    extends ManagedClusterVersionFluentImpl<ManagedClusterStatusFluent.VersionNested<N>>
    implements ManagedClusterStatusFluent.VersionNested<N>,
    Nested<N> {
        ManagedClusterVersionBuilder builder;

        VersionNestedImpl(ManagedClusterVersion item) {
            this.builder = new ManagedClusterVersionBuilder(this, item);
        }

        VersionNestedImpl() {
            this.builder = new ManagedClusterVersionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ManagedClusterStatusFluentImpl.this.withVersion(this.builder.build());
        }

        @Override
        public N endVersion() {
            return this.and();
        }
    }

    public class ClusterClaimsNestedImpl<N>
    extends ManagedClusterClaimFluentImpl<ManagedClusterStatusFluent.ClusterClaimsNested<N>>
    implements ManagedClusterStatusFluent.ClusterClaimsNested<N>,
    Nested<N> {
        ManagedClusterClaimBuilder builder;
        Integer index;

        ClusterClaimsNestedImpl(Integer index, ManagedClusterClaim item) {
            this.index = index;
            this.builder = new ManagedClusterClaimBuilder(this, item);
        }

        ClusterClaimsNestedImpl() {
            this.index = -1;
            this.builder = new ManagedClusterClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)ManagedClusterStatusFluentImpl.this.setToClusterClaims(this.index, this.builder.build());
        }

        @Override
        public N endClusterClaim() {
            return this.and();
        }
    }
}

