/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpec;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpecFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpecFluentImpl;
import java.util.Objects;

public class ManagedClusterSpecBuilder
extends ManagedClusterSpecFluentImpl<ManagedClusterSpecBuilder>
implements VisitableBuilder<ManagedClusterSpec, ManagedClusterSpecBuilder> {
    ManagedClusterSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ManagedClusterSpecBuilder() {
        this(false);
    }

    public ManagedClusterSpecBuilder(Boolean validationEnabled) {
        this(new ManagedClusterSpec(), validationEnabled);
    }

    public ManagedClusterSpecBuilder(ManagedClusterSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ManagedClusterSpecBuilder(ManagedClusterSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ManagedClusterSpec(), validationEnabled);
    }

    public ManagedClusterSpecBuilder(ManagedClusterSpecFluent<?> fluent, ManagedClusterSpec instance) {
        this(fluent, instance, false);
    }

    public ManagedClusterSpecBuilder(ManagedClusterSpecFluent<?> fluent, ManagedClusterSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHubAcceptsClient(instance.getHubAcceptsClient());
        fluent.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());
        fluent.withManagedClusterClientConfigs(instance.getManagedClusterClientConfigs());
        this.validationEnabled = validationEnabled;
    }

    public ManagedClusterSpecBuilder(ManagedClusterSpec instance) {
        this(instance, (Boolean)false);
    }

    public ManagedClusterSpecBuilder(ManagedClusterSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHubAcceptsClient(instance.getHubAcceptsClient());
        this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());
        this.withManagedClusterClientConfigs(instance.getManagedClusterClientConfigs());
        this.validationEnabled = validationEnabled;
    }

    public ManagedClusterSpec build() {
        ManagedClusterSpec buildable = new ManagedClusterSpec(this.fluent.getHubAcceptsClient(), this.fluent.getLeaseDurationSeconds(), this.fluent.getManagedClusterClientConfigs());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ManagedClusterSpecBuilder that = (ManagedClusterSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

