package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class ManagedClusterStatusFluentImpl<A extends io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent<A>{
  public ManagedClusterStatusFluentImpl() {
  }
  public ManagedClusterStatusFluentImpl(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatus instance) {
    this.withAllocatable(instance.getAllocatable()); 
    this.withCapacity(instance.getCapacity()); 
    this.withClusterClaims(instance.getClusterClaims()); 
    this.withConditions(instance.getConditions()); 
    this.withVersion(instance.getVersion()); 
  }
  private java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> allocatable;
  private java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> capacity;
  private java.util.List<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder> clusterClaims;
  private java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions;
  private io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersionBuilder version;
  public A addToAllocatable(java.lang.String key,io.fabric8.kubernetes.api.model.Quantity value) {
    if(this.allocatable == null && key != null && value != null) { this.allocatable = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.allocatable.put(key, value);} return (A)this;
  }
  public A addToAllocatable(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.allocatable == null && map != null) { this.allocatable = new java.util.LinkedHashMap(); }
    if(map != null) { this.allocatable.putAll(map);} return (A)this;
  }
  public A removeFromAllocatable(java.lang.String key) {
    if(this.allocatable == null) { return (A) this; }
    if(key != null && this.allocatable != null) {this.allocatable.remove(key);} return (A)this;
  }
  public A removeFromAllocatable(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.allocatable == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.allocatable != null){this.allocatable.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getAllocatable() {
    return this.allocatable;
  }
  public <K,V>A withAllocatable(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> allocatable) {
    if (allocatable == null) { this.allocatable =  null;} else {this.allocatable = new java.util.LinkedHashMap(allocatable);} return (A) this;
  }
  public java.lang.Boolean hasAllocatable() {
    return this.allocatable != null;
  }
  public A addToCapacity(java.lang.String key,io.fabric8.kubernetes.api.model.Quantity value) {
    if(this.capacity == null && key != null && value != null) { this.capacity = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
  }
  public A addToCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.capacity == null && map != null) { this.capacity = new java.util.LinkedHashMap(); }
    if(map != null) { this.capacity.putAll(map);} return (A)this;
  }
  public A removeFromCapacity(java.lang.String key) {
    if(this.capacity == null) { return (A) this; }
    if(key != null && this.capacity != null) {this.capacity.remove(key);} return (A)this;
  }
  public A removeFromCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.capacity == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capacity != null){this.capacity.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getCapacity() {
    return this.capacity;
  }
  public <K,V>A withCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> capacity) {
    if (capacity == null) { this.capacity =  null;} else {this.capacity = new java.util.LinkedHashMap(capacity);} return (A) this;
  }
  public java.lang.Boolean hasCapacity() {
    return this.capacity != null;
  }
  public A addToClusterClaims(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim item) {
    if (this.clusterClaims == null) {this.clusterClaims = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder>();}
    io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder builder = new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").add(index >= 0 ? index : _visitables.get("clusterClaims").size(), builder);this.clusterClaims.add(index >= 0 ? index : clusterClaims.size(), builder); return (A)this;
  }
  public A setToClusterClaims(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim item) {
    if (this.clusterClaims == null) {this.clusterClaims = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder>();}
    io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder builder = new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder(item);
    if (index < 0 || index >= _visitables.get("clusterClaims").size()) { _visitables.get("clusterClaims").add(builder); } else { _visitables.get("clusterClaims").set(index, builder);}
    if (index < 0 || index >= clusterClaims.size()) { clusterClaims.add(builder); } else { clusterClaims.set(index, builder);}
     return (A)this;
  }
  public A addToClusterClaims(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim... items) {
    if (this.clusterClaims == null) {this.clusterClaims = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder>();}
    for (io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim item : items) {io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder builder = new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").add(builder);this.clusterClaims.add(builder);} return (A)this;
  }
  public A addAllToClusterClaims(java.util.Collection<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim> items) {
    if (this.clusterClaims == null) {this.clusterClaims = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder>();}
    for (io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim item : items) {io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder builder = new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").add(builder);this.clusterClaims.add(builder);} return (A)this;
  }
  public A removeFromClusterClaims(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim... items) {
    for (io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim item : items) {io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder builder = new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").remove(builder);if (this.clusterClaims != null) {this.clusterClaims.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterClaims(java.util.Collection<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim> items) {
    for (io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim item : items) {io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder builder = new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").remove(builder);if (this.clusterClaims != null) {this.clusterClaims.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterClaims(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder> predicate) {
    if (clusterClaims == null) return (A) this;
    final Iterator<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder> each = clusterClaims.iterator();
    final List visitables = _visitables.get("clusterClaims");
    while (each.hasNext()) {
      io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterClaims instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim> getClusterClaims() {
    return build(clusterClaims);
  }
  public java.util.List<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim> buildClusterClaims() {
    return build(clusterClaims);
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim buildClusterClaim(java.lang.Integer index) {
    return this.clusterClaims.get(index).build();
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim buildFirstClusterClaim() {
    return this.clusterClaims.get(0).build();
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim buildLastClusterClaim() {
    return this.clusterClaims.get(clusterClaims.size() - 1).build();
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim buildMatchingClusterClaim(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder> predicate) {
    for (io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder item: clusterClaims) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingClusterClaim(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder> predicate) {
    for (io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder item: clusterClaims) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterClaims(java.util.List<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim> clusterClaims) {
    if (this.clusterClaims != null) { _visitables.get("clusterClaims").removeAll(this.clusterClaims);}
    if (clusterClaims != null) {this.clusterClaims = new java.util.ArrayList(); for (io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim item : clusterClaims){this.addToClusterClaims(item);}} else { this.clusterClaims = null;} return (A) this;
  }
  public A withClusterClaims(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim... clusterClaims) {
    if (this.clusterClaims != null) {this.clusterClaims.clear();}
    if (clusterClaims != null) {for (io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim item :clusterClaims){ this.addToClusterClaims(item);}} return (A) this;
  }
  public java.lang.Boolean hasClusterClaims() {
    return clusterClaims != null && !clusterClaims.isEmpty();
  }
  public A addNewClusterClaim(java.lang.String name,java.lang.String value) {
    return (A)addToClusterClaims(new ManagedClusterClaim(name, value));
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.ClusterClaimsNested<A> addNewClusterClaim() {
    return new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluentImpl.ClusterClaimsNestedImpl();
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.ClusterClaimsNested<A> addNewClusterClaimLike(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim item) {
    return new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluentImpl.ClusterClaimsNestedImpl(-1, item);
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.ClusterClaimsNested<A> setNewClusterClaimLike(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim item) {
    return new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluentImpl.ClusterClaimsNestedImpl(index, item);
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.ClusterClaimsNested<A> editClusterClaim(java.lang.Integer index) {
    if (clusterClaims.size() <= index) throw new RuntimeException("Can't edit clusterClaims. Index exceeds size.");
    return setNewClusterClaimLike(index, buildClusterClaim(index));
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.ClusterClaimsNested<A> editFirstClusterClaim() {
    if (clusterClaims.size() == 0) throw new RuntimeException("Can't edit first clusterClaims. The list is empty.");
    return setNewClusterClaimLike(0, buildClusterClaim(0));
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.ClusterClaimsNested<A> editLastClusterClaim() {
    int index = clusterClaims.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterClaims. The list is empty.");
    return setNewClusterClaimLike(index, buildClusterClaim(index));
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.ClusterClaimsNested<A> editMatchingClusterClaim(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterClaims.size();i++) { 
    if (predicate.test(clusterClaims.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterClaims. No match found.");
    return setNewClusterClaimLike(index, buildClusterClaim(index));
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Condition>();}
    for (io.fabric8.kubernetes.api.model.Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
    for (io.fabric8.kubernetes.api.model.Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Condition> getConditions() {
    return this.conditions;
  }
  public io.fabric8.kubernetes.api.model.Condition getCondition(java.lang.Integer index) {
    return this.conditions.get(index);
  }
  public io.fabric8.kubernetes.api.model.Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public io.fabric8.kubernetes.api.model.Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.Condition getMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Condition> predicate) {
    for (io.fabric8.kubernetes.api.model.Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions) {
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildVersion instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersion getVersion() {
    return this.version!=null?this.version.build():null;
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersion buildVersion() {
    return this.version!=null?this.version.build():null;
  }
  public A withVersion(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersion version) {
    _visitables.get("version").remove(this.version);
    if (version!=null){ this.version= new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersionBuilder(version); _visitables.get("version").add(this.version);} return (A) this;
  }
  public java.lang.Boolean hasVersion() {
    return this.version != null;
  }
  public A withNewVersion(java.lang.String kubernetes) {
    return (A)withVersion(new ManagedClusterVersion(kubernetes));
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.VersionNested<A> withNewVersion() {
    return new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluentImpl.VersionNestedImpl();
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.VersionNested<A> withNewVersionLike(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersion item) {
    return new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluentImpl.VersionNestedImpl(item);
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.VersionNested<A> editVersion() {
    return withNewVersionLike(getVersion());
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.VersionNested<A> editOrNewVersion() {
    return withNewVersionLike(getVersion() != null ? getVersion(): new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersionBuilder().build());
  }
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.VersionNested<A> editOrNewVersionLike(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersion item) {
    return withNewVersionLike(getVersion() != null ? getVersion(): item);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ManagedClusterStatusFluentImpl that = (ManagedClusterStatusFluentImpl) o;
    if (allocatable != null ? !allocatable.equals(that.allocatable) :that.allocatable != null) return false;
    if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
    if (clusterClaims != null ? !clusterClaims.equals(that.clusterClaims) :that.clusterClaims != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allocatable,  capacity,  clusterClaims,  conditions,  version,  super.hashCode());
  }
  public class ClusterClaimsNestedImpl<N> extends io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimFluentImpl<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.ClusterClaimsNested<N>> implements io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.ClusterClaimsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterClaimsNestedImpl(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim item) {
      this.index = index;
      this.builder = new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder(this, item);
    }
    ClusterClaimsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder(this);
    }
    io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaimBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ManagedClusterStatusFluentImpl.this.setToClusterClaims(index,builder.build());
    }
    public N endClusterClaim() {
      return and();
    }
    
  }
  public class VersionNestedImpl<N> extends io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersionFluentImpl<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.VersionNested<N>> implements io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluent.VersionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    VersionNestedImpl(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersion item) {
      this.builder = new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersionBuilder(this, item);
    }
    VersionNestedImpl() {
      this.builder = new io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersionBuilder(this);
    }
    io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterVersionBuilder builder;
    public N and() {
      return (N) ManagedClusterStatusFluentImpl.this.withVersion(builder.build());
    }
    public N endVersion() {
      return and();
    }
    
  }
  
}