package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ManagedClusterSpecBuilder extends io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpecFluentImpl<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpec,io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpecBuilder>{
  public ManagedClusterSpecBuilder() {
    this(false);
  }
  public ManagedClusterSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ManagedClusterSpec(), validationEnabled);
  }
  public ManagedClusterSpecBuilder(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedClusterSpecBuilder(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ManagedClusterSpec(), validationEnabled);
  }
  public ManagedClusterSpecBuilder(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpecFluent<?> fluent,io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpec instance) {
    this(fluent, instance, false);
  }
  public ManagedClusterSpecBuilder(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpecFluent<?> fluent,io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHubAcceptsClient(instance.getHubAcceptsClient()); 
    fluent.withLeaseDurationSeconds(instance.getLeaseDurationSeconds()); 
    fluent.withManagedClusterClientConfigs(instance.getManagedClusterClientConfigs()); 
    this.validationEnabled = validationEnabled; 
  }
  public ManagedClusterSpecBuilder(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpec instance) {
    this(instance,false);
  }
  public ManagedClusterSpecBuilder(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHubAcceptsClient(instance.getHubAcceptsClient()); 
    this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds()); 
    this.withManagedClusterClientConfigs(instance.getManagedClusterClientConfigs()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpec build() {
    ManagedClusterSpec buildable = new ManagedClusterSpec(fluent.getHubAcceptsClient(),fluent.getLeaseDurationSeconds(),fluent.getManagedClusterClientConfigs());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ManagedClusterSpecBuilder that = (ManagedClusterSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}