package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PlacementSpecBuilder extends io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpecFluentImpl<io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpec,io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpecBuilder>{
  public PlacementSpecBuilder() {
    this(false);
  }
  public PlacementSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new PlacementSpec(), validationEnabled);
  }
  public PlacementSpecBuilder(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementSpecBuilder(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PlacementSpec(), validationEnabled);
  }
  public PlacementSpecBuilder(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpecFluent<?> fluent,io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpec instance) {
    this(fluent, instance, false);
  }
  public PlacementSpecBuilder(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpecFluent<?> fluent,io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterSets(instance.getClusterSets()); 
    fluent.withNumberOfClusters(instance.getNumberOfClusters()); 
    fluent.withPredicates(instance.getPredicates()); 
    fluent.withPrioritizerPolicy(instance.getPrioritizerPolicy()); 
    this.validationEnabled = validationEnabled; 
  }
  public PlacementSpecBuilder(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpec instance) {
    this(instance,false);
  }
  public PlacementSpecBuilder(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterSets(instance.getClusterSets()); 
    this.withNumberOfClusters(instance.getNumberOfClusters()); 
    this.withPredicates(instance.getPredicates()); 
    this.withPrioritizerPolicy(instance.getPrioritizerPolicy()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.PlacementSpec build() {
    PlacementSpec buildable = new PlacementSpec(fluent.getClusterSets(),fluent.getNumberOfClusters(),fluent.getPredicates(),fluent.getPrioritizerPolicy());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlacementSpecBuilder that = (PlacementSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}