/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedCluster;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpec;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpecBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterSpecFluentImpl;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatus;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterStatusFluentImpl;
import java.util.Objects;

public class ManagedClusterFluentImpl<A extends ManagedClusterFluent<A>>
extends BaseFluent<A>
implements ManagedClusterFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ManagedClusterSpecBuilder spec;
    private ManagedClusterStatusBuilder status;

    public ManagedClusterFluentImpl() {
    }

    public ManagedClusterFluentImpl(ManagedCluster instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ManagedClusterFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ManagedClusterFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ManagedClusterFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ManagedClusterFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ManagedClusterFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ManagedClusterSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ManagedClusterSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ManagedClusterSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ManagedClusterSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ManagedClusterFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ManagedClusterFluent.SpecNested<A> withNewSpecLike(ManagedClusterSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ManagedClusterFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ManagedClusterFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ManagedClusterSpecBuilder().build());
    }

    @Override
    public ManagedClusterFluent.SpecNested<A> editOrNewSpecLike(ManagedClusterSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ManagedClusterStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ManagedClusterStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ManagedClusterStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new ManagedClusterStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ManagedClusterFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ManagedClusterFluent.StatusNested<A> withNewStatusLike(ManagedClusterStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ManagedClusterFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ManagedClusterFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ManagedClusterStatusBuilder().build());
    }

    @Override
    public ManagedClusterFluent.StatusNested<A> editOrNewStatusLike(ManagedClusterStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedClusterFluentImpl that = (ManagedClusterFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends ManagedClusterStatusFluentImpl<ManagedClusterFluent.StatusNested<N>>
    implements ManagedClusterFluent.StatusNested<N>,
    Nested<N> {
        ManagedClusterStatusBuilder builder;

        StatusNestedImpl(ManagedClusterStatus item) {
            this.builder = new ManagedClusterStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ManagedClusterStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ManagedClusterFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ManagedClusterSpecFluentImpl<ManagedClusterFluent.SpecNested<N>>
    implements ManagedClusterFluent.SpecNested<N>,
    Nested<N> {
        ManagedClusterSpecBuilder builder;

        SpecNestedImpl(ManagedClusterSpec item) {
            this.builder = new ManagedClusterSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ManagedClusterSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ManagedClusterFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ManagedClusterFluent.MetadataNested<N>>
    implements ManagedClusterFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)ManagedClusterFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

