package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ApplicationSpecBuilder extends ApplicationSpecFluent<ApplicationSpecBuilder> implements VisitableBuilder<ApplicationSpec,ApplicationSpecBuilder>{
  public ApplicationSpecBuilder() {
    this(new ApplicationSpec());
  }
  
  public ApplicationSpecBuilder(ApplicationSpecFluent<?> fluent) {
    this(fluent, new ApplicationSpec());
  }
  
  public ApplicationSpecBuilder(ApplicationSpecFluent<?> fluent,ApplicationSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ApplicationSpecBuilder(ApplicationSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ApplicationSpecFluent<?> fluent;
  
  public ApplicationSpec build() {
    ApplicationSpec buildable = new ApplicationSpec(fluent.getAddOwnerRef(),fluent.getAssemblyPhase(),fluent.getComponentKinds(),fluent.buildDescriptor(),fluent.buildInfo(),fluent.buildSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}