/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.AllowDenyItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class AllowDenyItemFluent<A extends AllowDenyItemFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private List<String> kinds = new ArrayList<String>();

    public AllowDenyItemFluent() {
    }

    public AllowDenyItemFluent(AllowDenyItem instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AllowDenyItem instance) {
        AllowDenyItem allowDenyItem = instance = instance != null ? instance : new AllowDenyItem();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKinds(instance.getKinds());
            this.withApiVersion(instance.getApiVersion());
            this.withKinds(instance.getKinds());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToKinds(int index, String item) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        this.kinds.add(index, item);
        return (A)((Object)this);
    }

    public A setToKinds(int index, String item) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        this.kinds.set(index, item);
        return (A)((Object)this);
    }

    public A addToKinds(String ... items) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        for (String item : items) {
            this.kinds.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToKinds(Collection<String> items) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        for (String item : items) {
            this.kinds.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromKinds(String ... items) {
        if (this.kinds == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.kinds.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromKinds(Collection<String> items) {
        if (this.kinds == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.kinds.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getKinds() {
        return this.kinds;
    }

    public String getKind(int index) {
        return this.kinds.get(index);
    }

    public String getFirstKind() {
        return this.kinds.get(0);
    }

    public String getLastKind() {
        return this.kinds.get(this.kinds.size() - 1);
    }

    public String getMatchingKind(Predicate<String> predicate) {
        for (String item : this.kinds) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingKind(Predicate<String> predicate) {
        for (String item : this.kinds) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withKinds(List<String> kinds) {
        if (kinds != null) {
            this.kinds = new ArrayList<String>();
            for (String item : kinds) {
                this.addToKinds(item);
            }
        } else {
            this.kinds = null;
        }
        return (A)((Object)this);
    }

    public A withKinds(String ... kinds) {
        if (this.kinds != null) {
            this.kinds.clear();
            this._visitables.remove((Object)"kinds");
        }
        if (kinds != null) {
            for (String item : kinds) {
                this.addToKinds(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasKinds() {
        return this.kinds != null && !this.kinds.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AllowDenyItemFluent that = (AllowDenyItemFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        return Objects.equals(this.kinds, that.kinds);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kinds, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kinds != null && !this.kinds.isEmpty()) {
            sb.append("kinds:");
            sb.append(this.kinds);
        }
        sb.append("}");
        return sb.toString();
    }
}

