/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1.GenericClusterReference;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1.GenericClusterReferenceBuilder;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1.GenericClusterReferenceFluent;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1.Placement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlacementFluent<A extends PlacementFluent<A>>
extends BaseFluent<A> {
    private LabelSelectorBuilder clusterSelector;
    private ArrayList<GenericClusterReferenceBuilder> clusters = new ArrayList();
    private Boolean local;
    private ObjectReferenceBuilder placementRef;

    public PlacementFluent() {
    }

    public PlacementFluent(Placement instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Placement instance) {
        Placement placement = instance = instance != null ? instance : new Placement();
        if (instance != null) {
            this.withClusterSelector(instance.getClusterSelector());
            this.withClusters(instance.getClusters());
            this.withLocal(instance.getLocal());
            this.withPlacementRef(instance.getPlacementRef());
            this.withClusterSelector(instance.getClusterSelector());
            this.withClusters(instance.getClusters());
            this.withLocal(instance.getLocal());
            this.withPlacementRef(instance.getPlacementRef());
        }
    }

    public LabelSelector buildClusterSelector() {
        return this.clusterSelector != null ? this.clusterSelector.build() : null;
    }

    public A withClusterSelector(LabelSelector clusterSelector) {
        this._visitables.remove((Object)this.clusterSelector);
        if (clusterSelector != null) {
            this.clusterSelector = new LabelSelectorBuilder(clusterSelector);
            this._visitables.get((Object)"clusterSelector").add(this.clusterSelector);
        } else {
            this.clusterSelector = null;
            this._visitables.get((Object)"clusterSelector").remove(this.clusterSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasClusterSelector() {
        return this.clusterSelector != null;
    }

    public ClusterSelectorNested<A> withNewClusterSelector() {
        return new ClusterSelectorNested(null);
    }

    public ClusterSelectorNested<A> withNewClusterSelectorLike(LabelSelector item) {
        return new ClusterSelectorNested(item);
    }

    public ClusterSelectorNested<A> editClusterSelector() {
        return this.withNewClusterSelectorLike(Optional.ofNullable(this.buildClusterSelector()).orElse(null));
    }

    public ClusterSelectorNested<A> editOrNewClusterSelector() {
        return this.withNewClusterSelectorLike(Optional.ofNullable(this.buildClusterSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public ClusterSelectorNested<A> editOrNewClusterSelectorLike(LabelSelector item) {
        return this.withNewClusterSelectorLike(Optional.ofNullable(this.buildClusterSelector()).orElse(item));
    }

    public A addToClusters(int index, GenericClusterReference item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
        if (index < 0 || index >= this.clusters.size()) {
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        } else {
            this._visitables.get((Object)"clusters").add(index, builder);
            this.clusters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToClusters(int index, GenericClusterReference item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
        if (index < 0 || index >= this.clusters.size()) {
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        } else {
            this._visitables.get((Object)"clusters").set(index, builder);
            this.clusters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToClusters(GenericClusterReference ... items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        for (GenericClusterReference item : items) {
            GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToClusters(Collection<GenericClusterReference> items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList();
        }
        for (GenericClusterReference item : items) {
            GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromClusters(GenericClusterReference ... items) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        for (GenericClusterReference item : items) {
            GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
            this._visitables.get((Object)"clusters").remove((Object)builder);
            this.clusters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusters(Collection<GenericClusterReference> items) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        for (GenericClusterReference item : items) {
            GenericClusterReferenceBuilder builder = new GenericClusterReferenceBuilder(item);
            this._visitables.get((Object)"clusters").remove((Object)builder);
            this.clusters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromClusters(Predicate<GenericClusterReferenceBuilder> predicate) {
        if (this.clusters == null) {
            return (A)((Object)this);
        }
        Iterator<GenericClusterReferenceBuilder> each = this.clusters.iterator();
        List visitables = this._visitables.get((Object)"clusters");
        while (each.hasNext()) {
            GenericClusterReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GenericClusterReference> buildClusters() {
        return this.clusters != null ? PlacementFluent.build(this.clusters) : null;
    }

    public GenericClusterReference buildCluster(int index) {
        return this.clusters.get(index).build();
    }

    public GenericClusterReference buildFirstCluster() {
        return this.clusters.get(0).build();
    }

    public GenericClusterReference buildLastCluster() {
        return this.clusters.get(this.clusters.size() - 1).build();
    }

    public GenericClusterReference buildMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
        for (GenericClusterReferenceBuilder item : this.clusters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
        for (GenericClusterReferenceBuilder item : this.clusters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusters(List<GenericClusterReference> clusters) {
        if (this.clusters != null) {
            this._visitables.get((Object)"clusters").clear();
        }
        if (clusters != null) {
            this.clusters = new ArrayList();
            for (GenericClusterReference item : clusters) {
                this.addToClusters(item);
            }
        } else {
            this.clusters = null;
        }
        return (A)((Object)this);
    }

    public A withClusters(GenericClusterReference ... clusters) {
        if (this.clusters != null) {
            this.clusters.clear();
            this._visitables.remove((Object)"clusters");
        }
        if (clusters != null) {
            for (GenericClusterReference item : clusters) {
                this.addToClusters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusters() {
        return this.clusters != null && !this.clusters.isEmpty();
    }

    public A addNewCluster(String name) {
        return this.addToClusters(new GenericClusterReference(name));
    }

    public ClustersNested<A> addNewCluster() {
        return new ClustersNested(-1, null);
    }

    public ClustersNested<A> addNewClusterLike(GenericClusterReference item) {
        return new ClustersNested(-1, item);
    }

    public ClustersNested<A> setNewClusterLike(int index, GenericClusterReference item) {
        return new ClustersNested(index, item);
    }

    public ClustersNested<A> editCluster(int index) {
        if (this.clusters.size() <= index) {
            throw new RuntimeException("Can't edit clusters. Index exceeds size.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public ClustersNested<A> editFirstCluster() {
        if (this.clusters.size() == 0) {
            throw new RuntimeException("Can't edit first clusters. The list is empty.");
        }
        return this.setNewClusterLike(0, this.buildCluster(0));
    }

    public ClustersNested<A> editLastCluster() {
        int index = this.clusters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusters. The list is empty.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public ClustersNested<A> editMatchingCluster(Predicate<GenericClusterReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (!predicate.test(this.clusters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusters. No match found.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    public Boolean getLocal() {
        return this.local;
    }

    public A withLocal(Boolean local) {
        this.local = local;
        return (A)((Object)this);
    }

    public boolean hasLocal() {
        return this.local != null;
    }

    public ObjectReference buildPlacementRef() {
        return this.placementRef != null ? this.placementRef.build() : null;
    }

    public A withPlacementRef(ObjectReference placementRef) {
        this._visitables.remove((Object)this.placementRef);
        if (placementRef != null) {
            this.placementRef = new ObjectReferenceBuilder(placementRef);
            this._visitables.get((Object)"placementRef").add(this.placementRef);
        } else {
            this.placementRef = null;
            this._visitables.get((Object)"placementRef").remove(this.placementRef);
        }
        return (A)((Object)this);
    }

    public boolean hasPlacementRef() {
        return this.placementRef != null;
    }

    public PlacementRefNested<A> withNewPlacementRef() {
        return new PlacementRefNested(null);
    }

    public PlacementRefNested<A> withNewPlacementRefLike(ObjectReference item) {
        return new PlacementRefNested(item);
    }

    public PlacementRefNested<A> editPlacementRef() {
        return this.withNewPlacementRefLike(Optional.ofNullable(this.buildPlacementRef()).orElse(null));
    }

    public PlacementRefNested<A> editOrNewPlacementRef() {
        return this.withNewPlacementRefLike(Optional.ofNullable(this.buildPlacementRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public PlacementRefNested<A> editOrNewPlacementRefLike(ObjectReference item) {
        return this.withNewPlacementRefLike(Optional.ofNullable(this.buildPlacementRef()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlacementFluent that = (PlacementFluent)((Object)o);
        if (!Objects.equals(this.clusterSelector, that.clusterSelector)) {
            return false;
        }
        if (!Objects.equals(this.clusters, that.clusters)) {
            return false;
        }
        if (!Objects.equals(this.local, that.local)) {
            return false;
        }
        return Objects.equals(this.placementRef, that.placementRef);
    }

    public int hashCode() {
        return Objects.hash(this.clusterSelector, this.clusters, this.local, this.placementRef, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterSelector != null) {
            sb.append("clusterSelector:");
            sb.append(this.clusterSelector + ",");
        }
        if (this.clusters != null && !this.clusters.isEmpty()) {
            sb.append("clusters:");
            sb.append(this.clusters + ",");
        }
        if (this.local != null) {
            sb.append("local:");
            sb.append(this.local + ",");
        }
        if (this.placementRef != null) {
            sb.append("placementRef:");
            sb.append(this.placementRef);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withLocal() {
        return this.withLocal(true);
    }

    public class PlacementRefNested<N>
    extends ObjectReferenceFluent<PlacementRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        PlacementRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)PlacementFluent.this.withPlacementRef(this.builder.build());
        }

        public N endPlacementRef() {
            return this.and();
        }
    }

    public class ClustersNested<N>
    extends GenericClusterReferenceFluent<ClustersNested<N>>
    implements Nested<N> {
        GenericClusterReferenceBuilder builder;
        int index;

        ClustersNested(int index, GenericClusterReference item) {
            this.index = index;
            this.builder = new GenericClusterReferenceBuilder(this, item);
        }

        public N and() {
            return (N)PlacementFluent.this.setToClusters(this.index, this.builder.build());
        }

        public N endCluster() {
            return this.and();
        }
    }

    public class ClusterSelectorNested<N>
    extends LabelSelectorFluent<ClusterSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        ClusterSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)PlacementFluent.this.withClusterSelector(this.builder.build());
        }

        public N endClusterSelector() {
            return this.and();
        }
    }
}

