/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1.HelmAppStatus;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1.HelmAppStatusBuilder;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1.HelmAppStatusFluent;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1.HelmRelease;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1.HelmReleaseRepo;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1.HelmReleaseRepoBuilder;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1.HelmReleaseRepoFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HelmReleaseFluent<A extends HelmReleaseFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private HelmReleaseRepoBuilder repo;
    private Map<String, Object> spec;
    private HelmAppStatusBuilder status;

    public HelmReleaseFluent() {
    }

    public HelmReleaseFluent(HelmRelease instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HelmRelease instance) {
        HelmRelease helmRelease = instance = instance != null ? instance : new HelmRelease();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRepo(instance.getRepo());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRepo(instance.getRepo());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public HelmReleaseRepo buildRepo() {
        return this.repo != null ? this.repo.build() : null;
    }

    public A withRepo(HelmReleaseRepo repo) {
        this._visitables.remove((Object)this.repo);
        if (repo != null) {
            this.repo = new HelmReleaseRepoBuilder(repo);
            this._visitables.get((Object)"repo").add(this.repo);
        } else {
            this.repo = null;
            this._visitables.get((Object)"repo").remove((Object)this.repo);
        }
        return (A)((Object)this);
    }

    public boolean hasRepo() {
        return this.repo != null;
    }

    public RepoNested<A> withNewRepo() {
        return new RepoNested(null);
    }

    public RepoNested<A> withNewRepoLike(HelmReleaseRepo item) {
        return new RepoNested(item);
    }

    public RepoNested<A> editRepo() {
        return this.withNewRepoLike(Optional.ofNullable(this.buildRepo()).orElse(null));
    }

    public RepoNested<A> editOrNewRepo() {
        return this.withNewRepoLike(Optional.ofNullable(this.buildRepo()).orElse(new HelmReleaseRepoBuilder().build()));
    }

    public RepoNested<A> editOrNewRepoLike(HelmReleaseRepo item) {
        return this.withNewRepoLike(Optional.ofNullable(this.buildRepo()).orElse(item));
    }

    public A addToSpec(String key, Object value) {
        if (this.spec == null && key != null && value != null) {
            this.spec = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.spec.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSpec(Map<String, Object> map) {
        if (this.spec == null && map != null) {
            this.spec = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.spec.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromSpec(String key) {
        if (this.spec == null) {
            return (A)((Object)this);
        }
        if (key != null && this.spec != null) {
            this.spec.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromSpec(Map<String, Object> map) {
        if (this.spec == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.spec == null) continue;
                this.spec.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getSpec() {
        return this.spec;
    }

    public <K, V> A withSpec(Map<String, Object> spec) {
        this.spec = spec == null ? null : new LinkedHashMap<String, Object>(spec);
        return (A)((Object)this);
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public HelmAppStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    public A withStatus(HelmAppStatus status) {
        this._visitables.remove((Object)this.status);
        if (status != null) {
            this.status = new HelmAppStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove((Object)this.status);
        }
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public StatusNested<A> withNewStatus() {
        return new StatusNested(null);
    }

    public StatusNested<A> withNewStatusLike(HelmAppStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<A> editStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(null));
    }

    public StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(new HelmAppStatusBuilder().build()));
    }

    public StatusNested<A> editOrNewStatusLike(HelmAppStatus item) {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HelmReleaseFluent that = (HelmReleaseFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals((Object)this.repo, (Object)that.repo)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        return Objects.equals((Object)this.status, (Object)that.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.kind, this.metadata, this.repo, this.spec, this.status, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.repo != null) {
            sb.append("repo:");
            sb.append((Object)((Object)this.repo) + ",");
        }
        if (this.spec != null && !this.spec.isEmpty()) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append((Object)this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StatusNested<N>
    extends HelmAppStatusFluent<StatusNested<N>>
    implements Nested<N> {
        HelmAppStatusBuilder builder;

        StatusNested(HelmAppStatus item) {
            this.builder = new HelmAppStatusBuilder(this, item);
        }

        public N and() {
            return (N)HelmReleaseFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }

    public class RepoNested<N>
    extends HelmReleaseRepoFluent<RepoNested<N>>
    implements Nested<N> {
        HelmReleaseRepoBuilder builder;

        RepoNested(HelmReleaseRepo item) {
            this.builder = new HelmReleaseRepoBuilder(this, item);
        }

        public N and() {
            return (N)HelmReleaseFluent.this.withRepo(this.builder.build());
        }

        public N endRepo() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)HelmReleaseFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

