/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.GroupKind;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpec;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorBuilder;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorFluent;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ApplicationSpecFluent<A extends ApplicationSpecFluent<A>>
extends BaseFluent<A> {
    private Boolean addOwnerRef;
    private String assemblyPhase;
    private List<GroupKind> componentKinds = new ArrayList<GroupKind>();
    private DescriptorBuilder descriptor;
    private ArrayList<InfoItemBuilder> info = new ArrayList();
    private LabelSelectorBuilder selector;

    public ApplicationSpecFluent() {
    }

    public ApplicationSpecFluent(ApplicationSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ApplicationSpec instance) {
        ApplicationSpec applicationSpec = instance = instance != null ? instance : new ApplicationSpec();
        if (instance != null) {
            this.withAddOwnerRef(instance.getAddOwnerRef());
            this.withAssemblyPhase(instance.getAssemblyPhase());
            this.withComponentKinds(instance.getComponentKinds());
            this.withDescriptor(instance.getDescriptor());
            this.withInfo(instance.getInfo());
            this.withSelector(instance.getSelector());
            this.withAddOwnerRef(instance.getAddOwnerRef());
            this.withAssemblyPhase(instance.getAssemblyPhase());
            this.withComponentKinds(instance.getComponentKinds());
            this.withDescriptor(instance.getDescriptor());
            this.withInfo(instance.getInfo());
            this.withSelector(instance.getSelector());
        }
    }

    public Boolean getAddOwnerRef() {
        return this.addOwnerRef;
    }

    public A withAddOwnerRef(Boolean addOwnerRef) {
        this.addOwnerRef = addOwnerRef;
        return (A)((Object)this);
    }

    public boolean hasAddOwnerRef() {
        return this.addOwnerRef != null;
    }

    public String getAssemblyPhase() {
        return this.assemblyPhase;
    }

    public A withAssemblyPhase(String assemblyPhase) {
        this.assemblyPhase = assemblyPhase;
        return (A)((Object)this);
    }

    public boolean hasAssemblyPhase() {
        return this.assemblyPhase != null;
    }

    public A addToComponentKinds(int index, GroupKind item) {
        if (this.componentKinds == null) {
            this.componentKinds = new ArrayList<GroupKind>();
        }
        this.componentKinds.add(index, item);
        return (A)((Object)this);
    }

    public A setToComponentKinds(int index, GroupKind item) {
        if (this.componentKinds == null) {
            this.componentKinds = new ArrayList<GroupKind>();
        }
        this.componentKinds.set(index, item);
        return (A)((Object)this);
    }

    public A addToComponentKinds(GroupKind ... items) {
        if (this.componentKinds == null) {
            this.componentKinds = new ArrayList<GroupKind>();
        }
        for (GroupKind item : items) {
            this.componentKinds.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToComponentKinds(Collection<GroupKind> items) {
        if (this.componentKinds == null) {
            this.componentKinds = new ArrayList<GroupKind>();
        }
        for (GroupKind item : items) {
            this.componentKinds.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromComponentKinds(GroupKind ... items) {
        if (this.componentKinds == null) {
            return (A)((Object)this);
        }
        for (GroupKind item : items) {
            this.componentKinds.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromComponentKinds(Collection<GroupKind> items) {
        if (this.componentKinds == null) {
            return (A)((Object)this);
        }
        for (GroupKind item : items) {
            this.componentKinds.remove(item);
        }
        return (A)((Object)this);
    }

    public List<GroupKind> getComponentKinds() {
        return this.componentKinds;
    }

    public GroupKind getComponentKind(int index) {
        return this.componentKinds.get(index);
    }

    public GroupKind getFirstComponentKind() {
        return this.componentKinds.get(0);
    }

    public GroupKind getLastComponentKind() {
        return this.componentKinds.get(this.componentKinds.size() - 1);
    }

    public GroupKind getMatchingComponentKind(Predicate<GroupKind> predicate) {
        for (GroupKind item : this.componentKinds) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingComponentKind(Predicate<GroupKind> predicate) {
        for (GroupKind item : this.componentKinds) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withComponentKinds(List<GroupKind> componentKinds) {
        if (componentKinds != null) {
            this.componentKinds = new ArrayList<GroupKind>();
            for (GroupKind item : componentKinds) {
                this.addToComponentKinds(item);
            }
        } else {
            this.componentKinds = null;
        }
        return (A)((Object)this);
    }

    public A withComponentKinds(GroupKind ... componentKinds) {
        if (this.componentKinds != null) {
            this.componentKinds.clear();
            this._visitables.remove((Object)"componentKinds");
        }
        if (componentKinds != null) {
            for (GroupKind item : componentKinds) {
                this.addToComponentKinds(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasComponentKinds() {
        return this.componentKinds != null && !this.componentKinds.isEmpty();
    }

    public A addNewComponentKind(String group, String kind) {
        return this.addToComponentKinds(new GroupKind(group, kind));
    }

    public Descriptor buildDescriptor() {
        return this.descriptor != null ? this.descriptor.build() : null;
    }

    public A withDescriptor(Descriptor descriptor) {
        this._visitables.remove((Object)this.descriptor);
        if (descriptor != null) {
            this.descriptor = new DescriptorBuilder(descriptor);
            this._visitables.get((Object)"descriptor").add(this.descriptor);
        } else {
            this.descriptor = null;
            this._visitables.get((Object)"descriptor").remove((Object)this.descriptor);
        }
        return (A)((Object)this);
    }

    public boolean hasDescriptor() {
        return this.descriptor != null;
    }

    public DescriptorNested<A> withNewDescriptor() {
        return new DescriptorNested(null);
    }

    public DescriptorNested<A> withNewDescriptorLike(Descriptor item) {
        return new DescriptorNested(item);
    }

    public DescriptorNested<A> editDescriptor() {
        return this.withNewDescriptorLike(Optional.ofNullable(this.buildDescriptor()).orElse(null));
    }

    public DescriptorNested<A> editOrNewDescriptor() {
        return this.withNewDescriptorLike(Optional.ofNullable(this.buildDescriptor()).orElse(new DescriptorBuilder().build()));
    }

    public DescriptorNested<A> editOrNewDescriptorLike(Descriptor item) {
        return this.withNewDescriptorLike(Optional.ofNullable(this.buildDescriptor()).orElse(item));
    }

    public A addToInfo(int index, InfoItem item) {
        if (this.info == null) {
            this.info = new ArrayList();
        }
        InfoItemBuilder builder = new InfoItemBuilder(item);
        if (index < 0 || index >= this.info.size()) {
            this._visitables.get((Object)"info").add(builder);
            this.info.add(builder);
        } else {
            this._visitables.get((Object)"info").add(index, builder);
            this.info.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToInfo(int index, InfoItem item) {
        if (this.info == null) {
            this.info = new ArrayList();
        }
        InfoItemBuilder builder = new InfoItemBuilder(item);
        if (index < 0 || index >= this.info.size()) {
            this._visitables.get((Object)"info").add(builder);
            this.info.add(builder);
        } else {
            this._visitables.get((Object)"info").set(index, builder);
            this.info.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToInfo(InfoItem ... items) {
        if (this.info == null) {
            this.info = new ArrayList();
        }
        for (InfoItem item : items) {
            InfoItemBuilder builder = new InfoItemBuilder(item);
            this._visitables.get((Object)"info").add(builder);
            this.info.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToInfo(Collection<InfoItem> items) {
        if (this.info == null) {
            this.info = new ArrayList();
        }
        for (InfoItem item : items) {
            InfoItemBuilder builder = new InfoItemBuilder(item);
            this._visitables.get((Object)"info").add(builder);
            this.info.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromInfo(InfoItem ... items) {
        if (this.info == null) {
            return (A)((Object)this);
        }
        for (InfoItem item : items) {
            InfoItemBuilder builder = new InfoItemBuilder(item);
            this._visitables.get((Object)"info").remove((Object)builder);
            this.info.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromInfo(Collection<InfoItem> items) {
        if (this.info == null) {
            return (A)((Object)this);
        }
        for (InfoItem item : items) {
            InfoItemBuilder builder = new InfoItemBuilder(item);
            this._visitables.get((Object)"info").remove((Object)builder);
            this.info.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromInfo(Predicate<InfoItemBuilder> predicate) {
        if (this.info == null) {
            return (A)((Object)this);
        }
        Iterator<InfoItemBuilder> each = this.info.iterator();
        List visitables = this._visitables.get((Object)"info");
        while (each.hasNext()) {
            InfoItemBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<InfoItem> buildInfo() {
        return this.info != null ? ApplicationSpecFluent.build(this.info) : null;
    }

    public InfoItem buildInfo(int index) {
        return this.info.get(index).build();
    }

    public InfoItem buildFirstInfo() {
        return this.info.get(0).build();
    }

    public InfoItem buildLastInfo() {
        return this.info.get(this.info.size() - 1).build();
    }

    public InfoItem buildMatchingInfo(Predicate<InfoItemBuilder> predicate) {
        for (InfoItemBuilder item : this.info) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInfo(Predicate<InfoItemBuilder> predicate) {
        for (InfoItemBuilder item : this.info) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInfo(List<InfoItem> info) {
        if (this.info != null) {
            this._visitables.get((Object)"info").clear();
        }
        if (info != null) {
            this.info = new ArrayList();
            for (InfoItem item : info) {
                this.addToInfo(item);
            }
        } else {
            this.info = null;
        }
        return (A)((Object)this);
    }

    public A withInfo(InfoItem ... info) {
        if (this.info != null) {
            this.info.clear();
            this._visitables.remove((Object)"info");
        }
        if (info != null) {
            for (InfoItem item : info) {
                this.addToInfo(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasInfo() {
        return this.info != null && !this.info.isEmpty();
    }

    public InfoNested<A> addNewInfo() {
        return new InfoNested(-1, null);
    }

    public InfoNested<A> addNewInfoLike(InfoItem item) {
        return new InfoNested(-1, item);
    }

    public InfoNested<A> setNewInfoLike(int index, InfoItem item) {
        return new InfoNested(index, item);
    }

    public InfoNested<A> editInfo(int index) {
        if (this.info.size() <= index) {
            throw new RuntimeException("Can't edit info. Index exceeds size.");
        }
        return this.setNewInfoLike(index, this.buildInfo(index));
    }

    public InfoNested<A> editFirstInfo() {
        if (this.info.size() == 0) {
            throw new RuntimeException("Can't edit first info. The list is empty.");
        }
        return this.setNewInfoLike(0, this.buildInfo(0));
    }

    public InfoNested<A> editLastInfo() {
        int index = this.info.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last info. The list is empty.");
        }
        return this.setNewInfoLike(index, this.buildInfo(index));
    }

    public InfoNested<A> editMatchingInfo(Predicate<InfoItemBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.info.size(); ++i) {
            if (!predicate.test(this.info.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching info. No match found.");
        }
        return this.setNewInfoLike(index, this.buildInfo(index));
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove((Object)this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplicationSpecFluent that = (ApplicationSpecFluent)((Object)o);
        if (!Objects.equals(this.addOwnerRef, that.addOwnerRef)) {
            return false;
        }
        if (!Objects.equals(this.assemblyPhase, that.assemblyPhase)) {
            return false;
        }
        if (!Objects.equals(this.componentKinds, that.componentKinds)) {
            return false;
        }
        if (!Objects.equals((Object)this.descriptor, (Object)that.descriptor)) {
            return false;
        }
        if (!Objects.equals(this.info, that.info)) {
            return false;
        }
        return Objects.equals(this.selector, that.selector);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addOwnerRef, this.assemblyPhase, this.componentKinds, this.descriptor, this.info, this.selector, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addOwnerRef != null) {
            sb.append("addOwnerRef:");
            sb.append(this.addOwnerRef + ",");
        }
        if (this.assemblyPhase != null) {
            sb.append("assemblyPhase:");
            sb.append(this.assemblyPhase + ",");
        }
        if (this.componentKinds != null && !this.componentKinds.isEmpty()) {
            sb.append("componentKinds:");
            sb.append(this.componentKinds + ",");
        }
        if (this.descriptor != null) {
            sb.append("descriptor:");
            sb.append((Object)((Object)this.descriptor) + ",");
        }
        if (this.info != null && !this.info.isEmpty()) {
            sb.append("info:");
            sb.append(this.info + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAddOwnerRef() {
        return this.withAddOwnerRef(true);
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)ApplicationSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class InfoNested<N>
    extends InfoItemFluent<InfoNested<N>>
    implements Nested<N> {
        InfoItemBuilder builder;
        int index;

        InfoNested(int index, InfoItem item) {
            this.index = index;
            this.builder = new InfoItemBuilder(this, item);
        }

        public N and() {
            return (N)ApplicationSpecFluent.this.setToInfo(this.index, this.builder.build());
        }

        public N endInfo() {
            return this.and();
        }
    }

    public class DescriptorNested<N>
    extends DescriptorFluent<DescriptorNested<N>>
    implements Nested<N> {
        DescriptorBuilder builder;

        DescriptorNested(Descriptor item) {
            this.builder = new DescriptorBuilder(this, item);
        }

        public N and() {
            return (N)ApplicationSpecFluent.this.withDescriptor(this.builder.build());
        }

        public N endDescriptor() {
            return this.and();
        }
    }
}

