package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SubscriptionStatusFluent<A extends SubscriptionStatusFluent<A>> extends BaseFluent<A>{
  public SubscriptionStatusFluent() {
  }
  
  public SubscriptionStatusFluent(SubscriptionStatus instance) {
    this.copyInstance(instance);
  }
  private AnsibleJobsStatusBuilder ansiblejobs;
  private String lastUpdateTime;
  private String message;
  private String phase;
  private String reason;
  private Map<String,SubscriptionPerClusterStatus> statuses;
  
  protected void copyInstance(SubscriptionStatus instance) {
    instance = (instance != null ? instance : new SubscriptionStatus());
    if (instance != null) {
          this.withAnsiblejobs(instance.getAnsiblejobs());
          this.withLastUpdateTime(instance.getLastUpdateTime());
          this.withMessage(instance.getMessage());
          this.withPhase(instance.getPhase());
          this.withReason(instance.getReason());
          this.withStatuses(instance.getStatuses());
          this.withAnsiblejobs(instance.getAnsiblejobs());
          this.withLastUpdateTime(instance.getLastUpdateTime());
          this.withMessage(instance.getMessage());
          this.withPhase(instance.getPhase());
          this.withReason(instance.getReason());
          this.withStatuses(instance.getStatuses());
        }
  }
  
  public AnsibleJobsStatus buildAnsiblejobs() {
    return this.ansiblejobs != null ? this.ansiblejobs.build() : null;
  }
  
  public A withAnsiblejobs(AnsibleJobsStatus ansiblejobs) {
    this._visitables.remove(this.ansiblejobs);
    if (ansiblejobs != null) {
        this.ansiblejobs = new AnsibleJobsStatusBuilder(ansiblejobs);
        this._visitables.get("ansiblejobs").add(this.ansiblejobs);
    } else {
        this.ansiblejobs = null;
        this._visitables.get("ansiblejobs").remove(this.ansiblejobs);
    }
    return (A) this;
  }
  
  public boolean hasAnsiblejobs() {
    return this.ansiblejobs != null;
  }
  
  public AnsiblejobsNested<A> withNewAnsiblejobs() {
    return new AnsiblejobsNested(null);
  }
  
  public AnsiblejobsNested<A> withNewAnsiblejobsLike(AnsibleJobsStatus item) {
    return new AnsiblejobsNested(item);
  }
  
  public AnsiblejobsNested<A> editAnsiblejobs() {
    return withNewAnsiblejobsLike(java.util.Optional.ofNullable(buildAnsiblejobs()).orElse(null));
  }
  
  public AnsiblejobsNested<A> editOrNewAnsiblejobs() {
    return withNewAnsiblejobsLike(java.util.Optional.ofNullable(buildAnsiblejobs()).orElse(new AnsibleJobsStatusBuilder().build()));
  }
  
  public AnsiblejobsNested<A> editOrNewAnsiblejobsLike(AnsibleJobsStatus item) {
    return withNewAnsiblejobsLike(java.util.Optional.ofNullable(buildAnsiblejobs()).orElse(item));
  }
  
  public String getLastUpdateTime() {
    return this.lastUpdateTime;
  }
  
  public A withLastUpdateTime(String lastUpdateTime) {
    this.lastUpdateTime = lastUpdateTime;
    return (A) this;
  }
  
  public boolean hasLastUpdateTime() {
    return this.lastUpdateTime != null;
  }
  
  public String getMessage() {
    return this.message;
  }
  
  public A withMessage(String message) {
    this.message = message;
    return (A) this;
  }
  
  public boolean hasMessage() {
    return this.message != null;
  }
  
  public String getPhase() {
    return this.phase;
  }
  
  public A withPhase(String phase) {
    this.phase = phase;
    return (A) this;
  }
  
  public boolean hasPhase() {
    return this.phase != null;
  }
  
  public String getReason() {
    return this.reason;
  }
  
  public A withReason(String reason) {
    this.reason = reason;
    return (A) this;
  }
  
  public boolean hasReason() {
    return this.reason != null;
  }
  
  public A addToStatuses(String key,SubscriptionPerClusterStatus value) {
    if(this.statuses == null && key != null && value != null) { this.statuses = new LinkedHashMap(); }
    if(key != null && value != null) {this.statuses.put(key, value);} return (A)this;
  }
  
  public A addToStatuses(Map<String,SubscriptionPerClusterStatus> map) {
    if(this.statuses == null && map != null) { this.statuses = new LinkedHashMap(); }
    if(map != null) { this.statuses.putAll(map);} return (A)this;
  }
  
  public A removeFromStatuses(String key) {
    if(this.statuses == null) { return (A) this; }
    if(key != null && this.statuses != null) {this.statuses.remove(key);} return (A)this;
  }
  
  public A removeFromStatuses(Map<String,SubscriptionPerClusterStatus> map) {
    if(this.statuses == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.statuses != null){this.statuses.remove(key);}}} return (A)this;
  }
  
  public Map<String,SubscriptionPerClusterStatus> getStatuses() {
    return this.statuses;
  }
  
  public <K,V>A withStatuses(Map<String,SubscriptionPerClusterStatus> statuses) {
    if (statuses == null) {
      this.statuses = null;
    } else {
      this.statuses = new LinkedHashMap(statuses);
    }
    return (A) this;
  }
  
  public boolean hasStatuses() {
    return this.statuses != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SubscriptionStatusFluent that = (SubscriptionStatusFluent) o;
    if (!java.util.Objects.equals(ansiblejobs, that.ansiblejobs)) return false;
    if (!java.util.Objects.equals(lastUpdateTime, that.lastUpdateTime)) return false;
    if (!java.util.Objects.equals(message, that.message)) return false;
    if (!java.util.Objects.equals(phase, that.phase)) return false;
    if (!java.util.Objects.equals(reason, that.reason)) return false;
    if (!java.util.Objects.equals(statuses, that.statuses)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ansiblejobs,  lastUpdateTime,  message,  phase,  reason,  statuses,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ansiblejobs != null) { sb.append("ansiblejobs:"); sb.append(ansiblejobs + ","); }
    if (lastUpdateTime != null) { sb.append("lastUpdateTime:"); sb.append(lastUpdateTime + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (statuses != null && !statuses.isEmpty()) { sb.append("statuses:"); sb.append(statuses); }
    sb.append("}");
    return sb.toString();
  }
  public class AnsiblejobsNested<N> extends AnsibleJobsStatusFluent<AnsiblejobsNested<N>> implements Nested<N>{
    AnsiblejobsNested(AnsibleJobsStatus item) {
      this.builder = new AnsibleJobsStatusBuilder(this, item);
    }
    AnsibleJobsStatusBuilder builder;
    
    public N and() {
      return (N) SubscriptionStatusFluent.this.withAnsiblejobs(builder.build());
    }
    
    public N endAnsiblejobs() {
      return and();
    }
    
  
  }

}