package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1.Placement;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1.PlacementBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.Iterator;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.placementrule.v1.PlacementFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SubscriptionSpecFluent<A extends SubscriptionSpecFluent<A>> extends BaseFluent<A>{
  public SubscriptionSpecFluent() {
  }
  
  public SubscriptionSpecFluent(SubscriptionSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<AllowDenyItemBuilder> allow = new ArrayList<AllowDenyItemBuilder>();
  private String channel;
  private ArrayList<AllowDenyItemBuilder> deny = new ArrayList<AllowDenyItemBuilder>();
  private ObjectReferenceBuilder hooksecretref;
  private String name;
  private ArrayList<ClusterOverridesBuilder> overrides = new ArrayList<ClusterOverridesBuilder>();
  private PackageFilterBuilder packageFilter;
  private ArrayList<OverridesBuilder> packageOverrides = new ArrayList<OverridesBuilder>();
  private PlacementBuilder placement;
  private String secondaryChannel;
  private TimeWindowBuilder timewindow;
  
  protected void copyInstance(SubscriptionSpec instance) {
    instance = (instance != null ? instance : new SubscriptionSpec());
    if (instance != null) {
          this.withAllow(instance.getAllow());
          this.withChannel(instance.getChannel());
          this.withDeny(instance.getDeny());
          this.withHooksecretref(instance.getHooksecretref());
          this.withName(instance.getName());
          this.withOverrides(instance.getOverrides());
          this.withPackageFilter(instance.getPackageFilter());
          this.withPackageOverrides(instance.getPackageOverrides());
          this.withPlacement(instance.getPlacement());
          this.withSecondaryChannel(instance.getSecondaryChannel());
          this.withTimewindow(instance.getTimewindow());
          this.withAllow(instance.getAllow());
          this.withChannel(instance.getChannel());
          this.withDeny(instance.getDeny());
          this.withHooksecretref(instance.getHooksecretref());
          this.withName(instance.getName());
          this.withOverrides(instance.getOverrides());
          this.withPackageFilter(instance.getPackageFilter());
          this.withPackageOverrides(instance.getPackageOverrides());
          this.withPlacement(instance.getPlacement());
          this.withSecondaryChannel(instance.getSecondaryChannel());
          this.withTimewindow(instance.getTimewindow());
        }
  }
  
  public A addToAllow(int index,AllowDenyItem item) {
    if (this.allow == null) {this.allow = new ArrayList<AllowDenyItemBuilder>();}
    AllowDenyItemBuilder builder = new AllowDenyItemBuilder(item);
    if (index < 0 || index >= allow.size()) { _visitables.get("allow").add(builder); allow.add(builder); } else { _visitables.get("allow").add(index, builder); allow.add(index, builder);}
    return (A)this;
  }
  
  public A setToAllow(int index,AllowDenyItem item) {
    if (this.allow == null) {this.allow = new ArrayList<AllowDenyItemBuilder>();}
    AllowDenyItemBuilder builder = new AllowDenyItemBuilder(item);
    if (index < 0 || index >= allow.size()) { _visitables.get("allow").add(builder); allow.add(builder); } else { _visitables.get("allow").set(index, builder); allow.set(index, builder);}
    return (A)this;
  }
  
  public A addToAllow(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.AllowDenyItem... items) {
    if (this.allow == null) {this.allow = new ArrayList<AllowDenyItemBuilder>();}
    for (AllowDenyItem item : items) {AllowDenyItemBuilder builder = new AllowDenyItemBuilder(item);_visitables.get("allow").add(builder);this.allow.add(builder);} return (A)this;
  }
  
  public A addAllToAllow(Collection<AllowDenyItem> items) {
    if (this.allow == null) {this.allow = new ArrayList<AllowDenyItemBuilder>();}
    for (AllowDenyItem item : items) {AllowDenyItemBuilder builder = new AllowDenyItemBuilder(item);_visitables.get("allow").add(builder);this.allow.add(builder);} return (A)this;
  }
  
  public A removeFromAllow(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.AllowDenyItem... items) {
    if (this.allow == null) return (A)this;
    for (AllowDenyItem item : items) {AllowDenyItemBuilder builder = new AllowDenyItemBuilder(item);_visitables.get("allow").remove(builder); this.allow.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAllow(Collection<AllowDenyItem> items) {
    if (this.allow == null) return (A)this;
    for (AllowDenyItem item : items) {AllowDenyItemBuilder builder = new AllowDenyItemBuilder(item);_visitables.get("allow").remove(builder); this.allow.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAllow(Predicate<AllowDenyItemBuilder> predicate) {
    if (allow == null) return (A) this;
    final Iterator<AllowDenyItemBuilder> each = allow.iterator();
    final List visitables = _visitables.get("allow");
    while (each.hasNext()) {
      AllowDenyItemBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AllowDenyItem> buildAllow() {
    return this.allow != null ? build(allow) : null;
  }
  
  public AllowDenyItem buildAllow(int index) {
    return this.allow.get(index).build();
  }
  
  public AllowDenyItem buildFirstAllow() {
    return this.allow.get(0).build();
  }
  
  public AllowDenyItem buildLastAllow() {
    return this.allow.get(allow.size() - 1).build();
  }
  
  public AllowDenyItem buildMatchingAllow(Predicate<AllowDenyItemBuilder> predicate) {
      for (AllowDenyItemBuilder item : allow) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAllow(Predicate<AllowDenyItemBuilder> predicate) {
      for (AllowDenyItemBuilder item : allow) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAllow(List<AllowDenyItem> allow) {
    if (this.allow != null) {
      this._visitables.get("allow").clear();
    }
    if (allow != null) {
        this.allow = new ArrayList();
        for (AllowDenyItem item : allow) {
          this.addToAllow(item);
        }
    } else {
      this.allow = null;
    }
    return (A) this;
  }
  
  public A withAllow(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.AllowDenyItem... allow) {
    if (this.allow != null) {this.allow.clear(); _visitables.remove("allow"); }
    if (allow != null) {for (AllowDenyItem item :allow){ this.addToAllow(item);}} return (A) this;
  }
  
  public boolean hasAllow() {
    return this.allow != null && !this.allow.isEmpty();
  }
  
  public AllowNested<A> addNewAllow() {
    return new AllowNested(-1, null);
  }
  
  public AllowNested<A> addNewAllowLike(AllowDenyItem item) {
    return new AllowNested(-1, item);
  }
  
  public AllowNested<A> setNewAllowLike(int index,AllowDenyItem item) {
    return new AllowNested(index, item);
  }
  
  public AllowNested<A> editAllow(int index) {
    if (allow.size() <= index) throw new RuntimeException("Can't edit allow. Index exceeds size.");
    return setNewAllowLike(index, buildAllow(index));
  }
  
  public AllowNested<A> editFirstAllow() {
    if (allow.size() == 0) throw new RuntimeException("Can't edit first allow. The list is empty.");
    return setNewAllowLike(0, buildAllow(0));
  }
  
  public AllowNested<A> editLastAllow() {
    int index = allow.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allow. The list is empty.");
    return setNewAllowLike(index, buildAllow(index));
  }
  
  public AllowNested<A> editMatchingAllow(Predicate<AllowDenyItemBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allow.size();i++) { 
    if (predicate.test(allow.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allow. No match found.");
    return setNewAllowLike(index, buildAllow(index));
  }
  
  public String getChannel() {
    return this.channel;
  }
  
  public A withChannel(String channel) {
    this.channel = channel;
    return (A) this;
  }
  
  public boolean hasChannel() {
    return this.channel != null;
  }
  
  public A addToDeny(int index,AllowDenyItem item) {
    if (this.deny == null) {this.deny = new ArrayList<AllowDenyItemBuilder>();}
    AllowDenyItemBuilder builder = new AllowDenyItemBuilder(item);
    if (index < 0 || index >= deny.size()) { _visitables.get("deny").add(builder); deny.add(builder); } else { _visitables.get("deny").add(index, builder); deny.add(index, builder);}
    return (A)this;
  }
  
  public A setToDeny(int index,AllowDenyItem item) {
    if (this.deny == null) {this.deny = new ArrayList<AllowDenyItemBuilder>();}
    AllowDenyItemBuilder builder = new AllowDenyItemBuilder(item);
    if (index < 0 || index >= deny.size()) { _visitables.get("deny").add(builder); deny.add(builder); } else { _visitables.get("deny").set(index, builder); deny.set(index, builder);}
    return (A)this;
  }
  
  public A addToDeny(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.AllowDenyItem... items) {
    if (this.deny == null) {this.deny = new ArrayList<AllowDenyItemBuilder>();}
    for (AllowDenyItem item : items) {AllowDenyItemBuilder builder = new AllowDenyItemBuilder(item);_visitables.get("deny").add(builder);this.deny.add(builder);} return (A)this;
  }
  
  public A addAllToDeny(Collection<AllowDenyItem> items) {
    if (this.deny == null) {this.deny = new ArrayList<AllowDenyItemBuilder>();}
    for (AllowDenyItem item : items) {AllowDenyItemBuilder builder = new AllowDenyItemBuilder(item);_visitables.get("deny").add(builder);this.deny.add(builder);} return (A)this;
  }
  
  public A removeFromDeny(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.AllowDenyItem... items) {
    if (this.deny == null) return (A)this;
    for (AllowDenyItem item : items) {AllowDenyItemBuilder builder = new AllowDenyItemBuilder(item);_visitables.get("deny").remove(builder); this.deny.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDeny(Collection<AllowDenyItem> items) {
    if (this.deny == null) return (A)this;
    for (AllowDenyItem item : items) {AllowDenyItemBuilder builder = new AllowDenyItemBuilder(item);_visitables.get("deny").remove(builder); this.deny.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDeny(Predicate<AllowDenyItemBuilder> predicate) {
    if (deny == null) return (A) this;
    final Iterator<AllowDenyItemBuilder> each = deny.iterator();
    final List visitables = _visitables.get("deny");
    while (each.hasNext()) {
      AllowDenyItemBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AllowDenyItem> buildDeny() {
    return this.deny != null ? build(deny) : null;
  }
  
  public AllowDenyItem buildDeny(int index) {
    return this.deny.get(index).build();
  }
  
  public AllowDenyItem buildFirstDeny() {
    return this.deny.get(0).build();
  }
  
  public AllowDenyItem buildLastDeny() {
    return this.deny.get(deny.size() - 1).build();
  }
  
  public AllowDenyItem buildMatchingDeny(Predicate<AllowDenyItemBuilder> predicate) {
      for (AllowDenyItemBuilder item : deny) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDeny(Predicate<AllowDenyItemBuilder> predicate) {
      for (AllowDenyItemBuilder item : deny) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDeny(List<AllowDenyItem> deny) {
    if (this.deny != null) {
      this._visitables.get("deny").clear();
    }
    if (deny != null) {
        this.deny = new ArrayList();
        for (AllowDenyItem item : deny) {
          this.addToDeny(item);
        }
    } else {
      this.deny = null;
    }
    return (A) this;
  }
  
  public A withDeny(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.AllowDenyItem... deny) {
    if (this.deny != null) {this.deny.clear(); _visitables.remove("deny"); }
    if (deny != null) {for (AllowDenyItem item :deny){ this.addToDeny(item);}} return (A) this;
  }
  
  public boolean hasDeny() {
    return this.deny != null && !this.deny.isEmpty();
  }
  
  public DenyNested<A> addNewDeny() {
    return new DenyNested(-1, null);
  }
  
  public DenyNested<A> addNewDenyLike(AllowDenyItem item) {
    return new DenyNested(-1, item);
  }
  
  public DenyNested<A> setNewDenyLike(int index,AllowDenyItem item) {
    return new DenyNested(index, item);
  }
  
  public DenyNested<A> editDeny(int index) {
    if (deny.size() <= index) throw new RuntimeException("Can't edit deny. Index exceeds size.");
    return setNewDenyLike(index, buildDeny(index));
  }
  
  public DenyNested<A> editFirstDeny() {
    if (deny.size() == 0) throw new RuntimeException("Can't edit first deny. The list is empty.");
    return setNewDenyLike(0, buildDeny(0));
  }
  
  public DenyNested<A> editLastDeny() {
    int index = deny.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last deny. The list is empty.");
    return setNewDenyLike(index, buildDeny(index));
  }
  
  public DenyNested<A> editMatchingDeny(Predicate<AllowDenyItemBuilder> predicate) {
    int index = -1;
    for (int i=0;i<deny.size();i++) { 
    if (predicate.test(deny.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching deny. No match found.");
    return setNewDenyLike(index, buildDeny(index));
  }
  
  public ObjectReference buildHooksecretref() {
    return this.hooksecretref != null ? this.hooksecretref.build() : null;
  }
  
  public A withHooksecretref(ObjectReference hooksecretref) {
    this._visitables.remove(this.hooksecretref);
    if (hooksecretref != null) {
        this.hooksecretref = new ObjectReferenceBuilder(hooksecretref);
        this._visitables.get("hooksecretref").add(this.hooksecretref);
    } else {
        this.hooksecretref = null;
        this._visitables.get("hooksecretref").remove(this.hooksecretref);
    }
    return (A) this;
  }
  
  public boolean hasHooksecretref() {
    return this.hooksecretref != null;
  }
  
  public HooksecretrefNested<A> withNewHooksecretref() {
    return new HooksecretrefNested(null);
  }
  
  public HooksecretrefNested<A> withNewHooksecretrefLike(ObjectReference item) {
    return new HooksecretrefNested(item);
  }
  
  public HooksecretrefNested<A> editHooksecretref() {
    return withNewHooksecretrefLike(java.util.Optional.ofNullable(buildHooksecretref()).orElse(null));
  }
  
  public HooksecretrefNested<A> editOrNewHooksecretref() {
    return withNewHooksecretrefLike(java.util.Optional.ofNullable(buildHooksecretref()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public HooksecretrefNested<A> editOrNewHooksecretrefLike(ObjectReference item) {
    return withNewHooksecretrefLike(java.util.Optional.ofNullable(buildHooksecretref()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToOverrides(int index,ClusterOverrides item) {
    if (this.overrides == null) {this.overrides = new ArrayList<ClusterOverridesBuilder>();}
    ClusterOverridesBuilder builder = new ClusterOverridesBuilder(item);
    if (index < 0 || index >= overrides.size()) { _visitables.get("overrides").add(builder); overrides.add(builder); } else { _visitables.get("overrides").add(index, builder); overrides.add(index, builder);}
    return (A)this;
  }
  
  public A setToOverrides(int index,ClusterOverrides item) {
    if (this.overrides == null) {this.overrides = new ArrayList<ClusterOverridesBuilder>();}
    ClusterOverridesBuilder builder = new ClusterOverridesBuilder(item);
    if (index < 0 || index >= overrides.size()) { _visitables.get("overrides").add(builder); overrides.add(builder); } else { _visitables.get("overrides").set(index, builder); overrides.set(index, builder);}
    return (A)this;
  }
  
  public A addToOverrides(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.ClusterOverrides... items) {
    if (this.overrides == null) {this.overrides = new ArrayList<ClusterOverridesBuilder>();}
    for (ClusterOverrides item : items) {ClusterOverridesBuilder builder = new ClusterOverridesBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
  }
  
  public A addAllToOverrides(Collection<ClusterOverrides> items) {
    if (this.overrides == null) {this.overrides = new ArrayList<ClusterOverridesBuilder>();}
    for (ClusterOverrides item : items) {ClusterOverridesBuilder builder = new ClusterOverridesBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
  }
  
  public A removeFromOverrides(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.ClusterOverrides... items) {
    if (this.overrides == null) return (A)this;
    for (ClusterOverrides item : items) {ClusterOverridesBuilder builder = new ClusterOverridesBuilder(item);_visitables.get("overrides").remove(builder); this.overrides.remove(builder);} return (A)this;
  }
  
  public A removeAllFromOverrides(Collection<ClusterOverrides> items) {
    if (this.overrides == null) return (A)this;
    for (ClusterOverrides item : items) {ClusterOverridesBuilder builder = new ClusterOverridesBuilder(item);_visitables.get("overrides").remove(builder); this.overrides.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromOverrides(Predicate<ClusterOverridesBuilder> predicate) {
    if (overrides == null) return (A) this;
    final Iterator<ClusterOverridesBuilder> each = overrides.iterator();
    final List visitables = _visitables.get("overrides");
    while (each.hasNext()) {
      ClusterOverridesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ClusterOverrides> buildOverrides() {
    return this.overrides != null ? build(overrides) : null;
  }
  
  public ClusterOverrides buildOverride(int index) {
    return this.overrides.get(index).build();
  }
  
  public ClusterOverrides buildFirstOverride() {
    return this.overrides.get(0).build();
  }
  
  public ClusterOverrides buildLastOverride() {
    return this.overrides.get(overrides.size() - 1).build();
  }
  
  public ClusterOverrides buildMatchingOverride(Predicate<ClusterOverridesBuilder> predicate) {
      for (ClusterOverridesBuilder item : overrides) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingOverride(Predicate<ClusterOverridesBuilder> predicate) {
      for (ClusterOverridesBuilder item : overrides) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withOverrides(List<ClusterOverrides> overrides) {
    if (this.overrides != null) {
      this._visitables.get("overrides").clear();
    }
    if (overrides != null) {
        this.overrides = new ArrayList();
        for (ClusterOverrides item : overrides) {
          this.addToOverrides(item);
        }
    } else {
      this.overrides = null;
    }
    return (A) this;
  }
  
  public A withOverrides(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.ClusterOverrides... overrides) {
    if (this.overrides != null) {this.overrides.clear(); _visitables.remove("overrides"); }
    if (overrides != null) {for (ClusterOverrides item :overrides){ this.addToOverrides(item);}} return (A) this;
  }
  
  public boolean hasOverrides() {
    return this.overrides != null && !this.overrides.isEmpty();
  }
  
  public OverridesNested<A> addNewOverride() {
    return new OverridesNested(-1, null);
  }
  
  public OverridesNested<A> addNewOverrideLike(ClusterOverrides item) {
    return new OverridesNested(-1, item);
  }
  
  public OverridesNested<A> setNewOverrideLike(int index,ClusterOverrides item) {
    return new OverridesNested(index, item);
  }
  
  public OverridesNested<A> editOverride(int index) {
    if (overrides.size() <= index) throw new RuntimeException("Can't edit overrides. Index exceeds size.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  
  public OverridesNested<A> editFirstOverride() {
    if (overrides.size() == 0) throw new RuntimeException("Can't edit first overrides. The list is empty.");
    return setNewOverrideLike(0, buildOverride(0));
  }
  
  public OverridesNested<A> editLastOverride() {
    int index = overrides.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last overrides. The list is empty.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  
  public OverridesNested<A> editMatchingOverride(Predicate<ClusterOverridesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<overrides.size();i++) { 
    if (predicate.test(overrides.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching overrides. No match found.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  
  public PackageFilter buildPackageFilter() {
    return this.packageFilter != null ? this.packageFilter.build() : null;
  }
  
  public A withPackageFilter(PackageFilter packageFilter) {
    this._visitables.remove(this.packageFilter);
    if (packageFilter != null) {
        this.packageFilter = new PackageFilterBuilder(packageFilter);
        this._visitables.get("packageFilter").add(this.packageFilter);
    } else {
        this.packageFilter = null;
        this._visitables.get("packageFilter").remove(this.packageFilter);
    }
    return (A) this;
  }
  
  public boolean hasPackageFilter() {
    return this.packageFilter != null;
  }
  
  public PackageFilterNested<A> withNewPackageFilter() {
    return new PackageFilterNested(null);
  }
  
  public PackageFilterNested<A> withNewPackageFilterLike(PackageFilter item) {
    return new PackageFilterNested(item);
  }
  
  public PackageFilterNested<A> editPackageFilter() {
    return withNewPackageFilterLike(java.util.Optional.ofNullable(buildPackageFilter()).orElse(null));
  }
  
  public PackageFilterNested<A> editOrNewPackageFilter() {
    return withNewPackageFilterLike(java.util.Optional.ofNullable(buildPackageFilter()).orElse(new PackageFilterBuilder().build()));
  }
  
  public PackageFilterNested<A> editOrNewPackageFilterLike(PackageFilter item) {
    return withNewPackageFilterLike(java.util.Optional.ofNullable(buildPackageFilter()).orElse(item));
  }
  
  public A addToPackageOverrides(int index,Overrides item) {
    if (this.packageOverrides == null) {this.packageOverrides = new ArrayList<OverridesBuilder>();}
    OverridesBuilder builder = new OverridesBuilder(item);
    if (index < 0 || index >= packageOverrides.size()) { _visitables.get("packageOverrides").add(builder); packageOverrides.add(builder); } else { _visitables.get("packageOverrides").add(index, builder); packageOverrides.add(index, builder);}
    return (A)this;
  }
  
  public A setToPackageOverrides(int index,Overrides item) {
    if (this.packageOverrides == null) {this.packageOverrides = new ArrayList<OverridesBuilder>();}
    OverridesBuilder builder = new OverridesBuilder(item);
    if (index < 0 || index >= packageOverrides.size()) { _visitables.get("packageOverrides").add(builder); packageOverrides.add(builder); } else { _visitables.get("packageOverrides").set(index, builder); packageOverrides.set(index, builder);}
    return (A)this;
  }
  
  public A addToPackageOverrides(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.Overrides... items) {
    if (this.packageOverrides == null) {this.packageOverrides = new ArrayList<OverridesBuilder>();}
    for (Overrides item : items) {OverridesBuilder builder = new OverridesBuilder(item);_visitables.get("packageOverrides").add(builder);this.packageOverrides.add(builder);} return (A)this;
  }
  
  public A addAllToPackageOverrides(Collection<Overrides> items) {
    if (this.packageOverrides == null) {this.packageOverrides = new ArrayList<OverridesBuilder>();}
    for (Overrides item : items) {OverridesBuilder builder = new OverridesBuilder(item);_visitables.get("packageOverrides").add(builder);this.packageOverrides.add(builder);} return (A)this;
  }
  
  public A removeFromPackageOverrides(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.Overrides... items) {
    if (this.packageOverrides == null) return (A)this;
    for (Overrides item : items) {OverridesBuilder builder = new OverridesBuilder(item);_visitables.get("packageOverrides").remove(builder); this.packageOverrides.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPackageOverrides(Collection<Overrides> items) {
    if (this.packageOverrides == null) return (A)this;
    for (Overrides item : items) {OverridesBuilder builder = new OverridesBuilder(item);_visitables.get("packageOverrides").remove(builder); this.packageOverrides.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPackageOverrides(Predicate<OverridesBuilder> predicate) {
    if (packageOverrides == null) return (A) this;
    final Iterator<OverridesBuilder> each = packageOverrides.iterator();
    final List visitables = _visitables.get("packageOverrides");
    while (each.hasNext()) {
      OverridesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Overrides> buildPackageOverrides() {
    return this.packageOverrides != null ? build(packageOverrides) : null;
  }
  
  public Overrides buildPackageOverride(int index) {
    return this.packageOverrides.get(index).build();
  }
  
  public Overrides buildFirstPackageOverride() {
    return this.packageOverrides.get(0).build();
  }
  
  public Overrides buildLastPackageOverride() {
    return this.packageOverrides.get(packageOverrides.size() - 1).build();
  }
  
  public Overrides buildMatchingPackageOverride(Predicate<OverridesBuilder> predicate) {
      for (OverridesBuilder item : packageOverrides) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPackageOverride(Predicate<OverridesBuilder> predicate) {
      for (OverridesBuilder item : packageOverrides) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPackageOverrides(List<Overrides> packageOverrides) {
    if (this.packageOverrides != null) {
      this._visitables.get("packageOverrides").clear();
    }
    if (packageOverrides != null) {
        this.packageOverrides = new ArrayList();
        for (Overrides item : packageOverrides) {
          this.addToPackageOverrides(item);
        }
    } else {
      this.packageOverrides = null;
    }
    return (A) this;
  }
  
  public A withPackageOverrides(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.Overrides... packageOverrides) {
    if (this.packageOverrides != null) {this.packageOverrides.clear(); _visitables.remove("packageOverrides"); }
    if (packageOverrides != null) {for (Overrides item :packageOverrides){ this.addToPackageOverrides(item);}} return (A) this;
  }
  
  public boolean hasPackageOverrides() {
    return this.packageOverrides != null && !this.packageOverrides.isEmpty();
  }
  
  public PackageOverridesNested<A> addNewPackageOverride() {
    return new PackageOverridesNested(-1, null);
  }
  
  public PackageOverridesNested<A> addNewPackageOverrideLike(Overrides item) {
    return new PackageOverridesNested(-1, item);
  }
  
  public PackageOverridesNested<A> setNewPackageOverrideLike(int index,Overrides item) {
    return new PackageOverridesNested(index, item);
  }
  
  public PackageOverridesNested<A> editPackageOverride(int index) {
    if (packageOverrides.size() <= index) throw new RuntimeException("Can't edit packageOverrides. Index exceeds size.");
    return setNewPackageOverrideLike(index, buildPackageOverride(index));
  }
  
  public PackageOverridesNested<A> editFirstPackageOverride() {
    if (packageOverrides.size() == 0) throw new RuntimeException("Can't edit first packageOverrides. The list is empty.");
    return setNewPackageOverrideLike(0, buildPackageOverride(0));
  }
  
  public PackageOverridesNested<A> editLastPackageOverride() {
    int index = packageOverrides.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last packageOverrides. The list is empty.");
    return setNewPackageOverrideLike(index, buildPackageOverride(index));
  }
  
  public PackageOverridesNested<A> editMatchingPackageOverride(Predicate<OverridesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<packageOverrides.size();i++) { 
    if (predicate.test(packageOverrides.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching packageOverrides. No match found.");
    return setNewPackageOverrideLike(index, buildPackageOverride(index));
  }
  
  public Placement buildPlacement() {
    return this.placement != null ? this.placement.build() : null;
  }
  
  public A withPlacement(Placement placement) {
    this._visitables.remove(this.placement);
    if (placement != null) {
        this.placement = new PlacementBuilder(placement);
        this._visitables.get("placement").add(this.placement);
    } else {
        this.placement = null;
        this._visitables.get("placement").remove(this.placement);
    }
    return (A) this;
  }
  
  public boolean hasPlacement() {
    return this.placement != null;
  }
  
  public PlacementNested<A> withNewPlacement() {
    return new PlacementNested(null);
  }
  
  public PlacementNested<A> withNewPlacementLike(Placement item) {
    return new PlacementNested(item);
  }
  
  public PlacementNested<A> editPlacement() {
    return withNewPlacementLike(java.util.Optional.ofNullable(buildPlacement()).orElse(null));
  }
  
  public PlacementNested<A> editOrNewPlacement() {
    return withNewPlacementLike(java.util.Optional.ofNullable(buildPlacement()).orElse(new PlacementBuilder().build()));
  }
  
  public PlacementNested<A> editOrNewPlacementLike(Placement item) {
    return withNewPlacementLike(java.util.Optional.ofNullable(buildPlacement()).orElse(item));
  }
  
  public String getSecondaryChannel() {
    return this.secondaryChannel;
  }
  
  public A withSecondaryChannel(String secondaryChannel) {
    this.secondaryChannel = secondaryChannel;
    return (A) this;
  }
  
  public boolean hasSecondaryChannel() {
    return this.secondaryChannel != null;
  }
  
  public TimeWindow buildTimewindow() {
    return this.timewindow != null ? this.timewindow.build() : null;
  }
  
  public A withTimewindow(TimeWindow timewindow) {
    this._visitables.remove(this.timewindow);
    if (timewindow != null) {
        this.timewindow = new TimeWindowBuilder(timewindow);
        this._visitables.get("timewindow").add(this.timewindow);
    } else {
        this.timewindow = null;
        this._visitables.get("timewindow").remove(this.timewindow);
    }
    return (A) this;
  }
  
  public boolean hasTimewindow() {
    return this.timewindow != null;
  }
  
  public TimewindowNested<A> withNewTimewindow() {
    return new TimewindowNested(null);
  }
  
  public TimewindowNested<A> withNewTimewindowLike(TimeWindow item) {
    return new TimewindowNested(item);
  }
  
  public TimewindowNested<A> editTimewindow() {
    return withNewTimewindowLike(java.util.Optional.ofNullable(buildTimewindow()).orElse(null));
  }
  
  public TimewindowNested<A> editOrNewTimewindow() {
    return withNewTimewindowLike(java.util.Optional.ofNullable(buildTimewindow()).orElse(new TimeWindowBuilder().build()));
  }
  
  public TimewindowNested<A> editOrNewTimewindowLike(TimeWindow item) {
    return withNewTimewindowLike(java.util.Optional.ofNullable(buildTimewindow()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SubscriptionSpecFluent that = (SubscriptionSpecFluent) o;
    if (!java.util.Objects.equals(allow, that.allow)) return false;
    if (!java.util.Objects.equals(channel, that.channel)) return false;
    if (!java.util.Objects.equals(deny, that.deny)) return false;
    if (!java.util.Objects.equals(hooksecretref, that.hooksecretref)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(overrides, that.overrides)) return false;
    if (!java.util.Objects.equals(packageFilter, that.packageFilter)) return false;
    if (!java.util.Objects.equals(packageOverrides, that.packageOverrides)) return false;
    if (!java.util.Objects.equals(placement, that.placement)) return false;
    if (!java.util.Objects.equals(secondaryChannel, that.secondaryChannel)) return false;
    if (!java.util.Objects.equals(timewindow, that.timewindow)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allow,  channel,  deny,  hooksecretref,  name,  overrides,  packageFilter,  packageOverrides,  placement,  secondaryChannel,  timewindow,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allow != null && !allow.isEmpty()) { sb.append("allow:"); sb.append(allow + ","); }
    if (channel != null) { sb.append("channel:"); sb.append(channel + ","); }
    if (deny != null && !deny.isEmpty()) { sb.append("deny:"); sb.append(deny + ","); }
    if (hooksecretref != null) { sb.append("hooksecretref:"); sb.append(hooksecretref + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (overrides != null && !overrides.isEmpty()) { sb.append("overrides:"); sb.append(overrides + ","); }
    if (packageFilter != null) { sb.append("packageFilter:"); sb.append(packageFilter + ","); }
    if (packageOverrides != null && !packageOverrides.isEmpty()) { sb.append("packageOverrides:"); sb.append(packageOverrides + ","); }
    if (placement != null) { sb.append("placement:"); sb.append(placement + ","); }
    if (secondaryChannel != null) { sb.append("secondaryChannel:"); sb.append(secondaryChannel + ","); }
    if (timewindow != null) { sb.append("timewindow:"); sb.append(timewindow); }
    sb.append("}");
    return sb.toString();
  }
  public class AllowNested<N> extends AllowDenyItemFluent<AllowNested<N>> implements Nested<N>{
    AllowNested(int index,AllowDenyItem item) {
      this.index = index;
      this.builder = new AllowDenyItemBuilder(this, item);
    }
    AllowDenyItemBuilder builder;
    int index;
    
    public N and() {
      return (N) SubscriptionSpecFluent.this.setToAllow(index,builder.build());
    }
    
    public N endAllow() {
      return and();
    }
    
  
  }
  public class DenyNested<N> extends AllowDenyItemFluent<DenyNested<N>> implements Nested<N>{
    DenyNested(int index,AllowDenyItem item) {
      this.index = index;
      this.builder = new AllowDenyItemBuilder(this, item);
    }
    AllowDenyItemBuilder builder;
    int index;
    
    public N and() {
      return (N) SubscriptionSpecFluent.this.setToDeny(index,builder.build());
    }
    
    public N endDeny() {
      return and();
    }
    
  
  }
  public class HooksecretrefNested<N> extends ObjectReferenceFluent<HooksecretrefNested<N>> implements Nested<N>{
    HooksecretrefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) SubscriptionSpecFluent.this.withHooksecretref(builder.build());
    }
    
    public N endHooksecretref() {
      return and();
    }
    
  
  }
  public class OverridesNested<N> extends ClusterOverridesFluent<OverridesNested<N>> implements Nested<N>{
    OverridesNested(int index,ClusterOverrides item) {
      this.index = index;
      this.builder = new ClusterOverridesBuilder(this, item);
    }
    ClusterOverridesBuilder builder;
    int index;
    
    public N and() {
      return (N) SubscriptionSpecFluent.this.setToOverrides(index,builder.build());
    }
    
    public N endOverride() {
      return and();
    }
    
  
  }
  public class PackageFilterNested<N> extends PackageFilterFluent<PackageFilterNested<N>> implements Nested<N>{
    PackageFilterNested(PackageFilter item) {
      this.builder = new PackageFilterBuilder(this, item);
    }
    PackageFilterBuilder builder;
    
    public N and() {
      return (N) SubscriptionSpecFluent.this.withPackageFilter(builder.build());
    }
    
    public N endPackageFilter() {
      return and();
    }
    
  
  }
  public class PackageOverridesNested<N> extends OverridesFluent<PackageOverridesNested<N>> implements Nested<N>{
    PackageOverridesNested(int index,Overrides item) {
      this.index = index;
      this.builder = new OverridesBuilder(this, item);
    }
    OverridesBuilder builder;
    int index;
    
    public N and() {
      return (N) SubscriptionSpecFluent.this.setToPackageOverrides(index,builder.build());
    }
    
    public N endPackageOverride() {
      return and();
    }
    
  
  }
  public class PlacementNested<N> extends PlacementFluent<PlacementNested<N>> implements Nested<N>{
    PlacementNested(Placement item) {
      this.builder = new PlacementBuilder(this, item);
    }
    PlacementBuilder builder;
    
    public N and() {
      return (N) SubscriptionSpecFluent.this.withPlacement(builder.build());
    }
    
    public N endPlacement() {
      return and();
    }
    
  
  }
  public class TimewindowNested<N> extends TimeWindowFluent<TimewindowNested<N>> implements Nested<N>{
    TimewindowNested(TimeWindow item) {
      this.builder = new TimeWindowBuilder(this, item);
    }
    TimeWindowBuilder builder;
    
    public N and() {
      return (N) SubscriptionSpecFluent.this.withTimewindow(builder.build());
    }
    
    public N endTimewindow() {
      return and();
    }
    
  
  }

}