package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OverridesFluent<A extends OverridesFluent<A>> extends BaseFluent<A>{
  public OverridesFluent() {
  }
  
  public OverridesFluent(Overrides instance) {
    this.copyInstance(instance);
  }
  private String packageAlias;
  private String packageName;
  private List<Map<String,Object>> packageOverrides = new ArrayList<Map<String,Object>>();
  
  protected void copyInstance(Overrides instance) {
    instance = (instance != null ? instance : new Overrides());
    if (instance != null) {
          this.withPackageAlias(instance.getPackageAlias());
          this.withPackageName(instance.getPackageName());
          this.withPackageOverrides(instance.getPackageOverrides());
          this.withPackageAlias(instance.getPackageAlias());
          this.withPackageName(instance.getPackageName());
          this.withPackageOverrides(instance.getPackageOverrides());
        }
  }
  
  public String getPackageAlias() {
    return this.packageAlias;
  }
  
  public A withPackageAlias(String packageAlias) {
    this.packageAlias = packageAlias;
    return (A) this;
  }
  
  public boolean hasPackageAlias() {
    return this.packageAlias != null;
  }
  
  public String getPackageName() {
    return this.packageName;
  }
  
  public A withPackageName(String packageName) {
    this.packageName = packageName;
    return (A) this;
  }
  
  public boolean hasPackageName() {
    return this.packageName != null;
  }
  
  public A addToPackageOverrides(int index,Map<String,Object> item) {
    if (this.packageOverrides == null) {this.packageOverrides = new ArrayList<Map<String,Object>>();}
    this.packageOverrides.add(index, item);
    return (A)this;
  }
  
  public A setToPackageOverrides(int index,Map<String,Object> item) {
    if (this.packageOverrides == null) {this.packageOverrides = new ArrayList<Map<String,Object>>();}
    this.packageOverrides.set(index, item); return (A)this;
  }
  
  public A addToPackageOverrides(Map<String,Object>... items) {
    if (this.packageOverrides == null) {this.packageOverrides = new ArrayList<Map<String,Object>>();}
    for (Map<String,Object> item : items) {this.packageOverrides.add(item);} return (A)this;
  }
  
  public A addAllToPackageOverrides(Collection<Map<String,Object>> items) {
    if (this.packageOverrides == null) {this.packageOverrides = new ArrayList<Map<String,Object>>();}
    for (Map<String,Object> item : items) {this.packageOverrides.add(item);} return (A)this;
  }
  
  public A removeFromPackageOverrides(Map<String,Object>... items) {
    if (this.packageOverrides == null) return (A)this;
    for (Map<String,Object> item : items) { this.packageOverrides.remove(item);} return (A)this;
  }
  
  public A removeAllFromPackageOverrides(Collection<Map<String,Object>> items) {
    if (this.packageOverrides == null) return (A)this;
    for (Map<String,Object> item : items) { this.packageOverrides.remove(item);} return (A)this;
  }
  
  public List<Map<String,Object>> getPackageOverrides() {
    return this.packageOverrides;
  }
  
  public Map<String,Object> getPackageOverride(int index) {
    return this.packageOverrides.get(index);
  }
  
  public Map<String,Object> getFirstPackageOverride() {
    return this.packageOverrides.get(0);
  }
  
  public Map<String,Object> getLastPackageOverride() {
    return this.packageOverrides.get(packageOverrides.size() - 1);
  }
  
  public Map<String,Object> getMatchingPackageOverride(Predicate<Map<String,Object>> predicate) {
      for (Map<String,Object> item : packageOverrides) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingPackageOverride(Predicate<Map<String,Object>> predicate) {
      for (Map<String,Object> item : packageOverrides) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public <K,V>A withPackageOverrides(List<Map<String,Object>> packageOverrides) {
    if (packageOverrides != null) {
        this.packageOverrides = new ArrayList();
        for (Map<String,Object> item : packageOverrides) {
          this.addToPackageOverrides(item);
        }
    } else {
      this.packageOverrides = null;
    }
    return (A) this;
  }
  
  public A withPackageOverrides(Map<String,Object>... packageOverrides) {
    if (this.packageOverrides != null) {this.packageOverrides.clear(); _visitables.remove("packageOverrides"); }
    if (packageOverrides != null) {for (Map<String,Object> item :packageOverrides){ this.addToPackageOverrides(item);}} return (A) this;
  }
  
  public boolean hasPackageOverrides() {
    return this.packageOverrides != null && !this.packageOverrides.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OverridesFluent that = (OverridesFluent) o;
    if (!java.util.Objects.equals(packageAlias, that.packageAlias)) return false;
    if (!java.util.Objects.equals(packageName, that.packageName)) return false;
    if (!java.util.Objects.equals(packageOverrides, that.packageOverrides)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(packageAlias,  packageName,  packageOverrides,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (packageAlias != null) { sb.append("packageAlias:"); sb.append(packageAlias + ","); }
    if (packageName != null) { sb.append("packageName:"); sb.append(packageName + ","); }
    if (packageOverrides != null && !packageOverrides.isEmpty()) { sb.append("packageOverrides:"); sb.append(packageOverrides); }
    sb.append("}");
    return sb.toString();
  }
  

}