package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterOverridesFluent<A extends ClusterOverridesFluent<A>> extends BaseFluent<A>{
  public ClusterOverridesFluent() {
  }
  
  public ClusterOverridesFluent(ClusterOverrides instance) {
    this.copyInstance(instance);
  }
  private String clusterName;
  private ArrayList<ClusterOverrideBuilder> clusterOverrides = new ArrayList<ClusterOverrideBuilder>();
  
  protected void copyInstance(ClusterOverrides instance) {
    instance = (instance != null ? instance : new ClusterOverrides());
    if (instance != null) {
          this.withClusterName(instance.getClusterName());
          this.withClusterOverrides(instance.getClusterOverrides());
          this.withClusterName(instance.getClusterName());
          this.withClusterOverrides(instance.getClusterOverrides());
        }
  }
  
  public String getClusterName() {
    return this.clusterName;
  }
  
  public A withClusterName(String clusterName) {
    this.clusterName = clusterName;
    return (A) this;
  }
  
  public boolean hasClusterName() {
    return this.clusterName != null;
  }
  
  public A addToClusterOverrides(int index,ClusterOverride item) {
    if (this.clusterOverrides == null) {this.clusterOverrides = new ArrayList<ClusterOverrideBuilder>();}
    ClusterOverrideBuilder builder = new ClusterOverrideBuilder(item);
    if (index < 0 || index >= clusterOverrides.size()) { _visitables.get("clusterOverrides").add(builder); clusterOverrides.add(builder); } else { _visitables.get("clusterOverrides").add(index, builder); clusterOverrides.add(index, builder);}
    return (A)this;
  }
  
  public A setToClusterOverrides(int index,ClusterOverride item) {
    if (this.clusterOverrides == null) {this.clusterOverrides = new ArrayList<ClusterOverrideBuilder>();}
    ClusterOverrideBuilder builder = new ClusterOverrideBuilder(item);
    if (index < 0 || index >= clusterOverrides.size()) { _visitables.get("clusterOverrides").add(builder); clusterOverrides.add(builder); } else { _visitables.get("clusterOverrides").set(index, builder); clusterOverrides.set(index, builder);}
    return (A)this;
  }
  
  public A addToClusterOverrides(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.ClusterOverride... items) {
    if (this.clusterOverrides == null) {this.clusterOverrides = new ArrayList<ClusterOverrideBuilder>();}
    for (ClusterOverride item : items) {ClusterOverrideBuilder builder = new ClusterOverrideBuilder(item);_visitables.get("clusterOverrides").add(builder);this.clusterOverrides.add(builder);} return (A)this;
  }
  
  public A addAllToClusterOverrides(Collection<ClusterOverride> items) {
    if (this.clusterOverrides == null) {this.clusterOverrides = new ArrayList<ClusterOverrideBuilder>();}
    for (ClusterOverride item : items) {ClusterOverrideBuilder builder = new ClusterOverrideBuilder(item);_visitables.get("clusterOverrides").add(builder);this.clusterOverrides.add(builder);} return (A)this;
  }
  
  public A removeFromClusterOverrides(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.ClusterOverride... items) {
    if (this.clusterOverrides == null) return (A)this;
    for (ClusterOverride item : items) {ClusterOverrideBuilder builder = new ClusterOverrideBuilder(item);_visitables.get("clusterOverrides").remove(builder); this.clusterOverrides.remove(builder);} return (A)this;
  }
  
  public A removeAllFromClusterOverrides(Collection<ClusterOverride> items) {
    if (this.clusterOverrides == null) return (A)this;
    for (ClusterOverride item : items) {ClusterOverrideBuilder builder = new ClusterOverrideBuilder(item);_visitables.get("clusterOverrides").remove(builder); this.clusterOverrides.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromClusterOverrides(Predicate<ClusterOverrideBuilder> predicate) {
    if (clusterOverrides == null) return (A) this;
    final Iterator<ClusterOverrideBuilder> each = clusterOverrides.iterator();
    final List visitables = _visitables.get("clusterOverrides");
    while (each.hasNext()) {
      ClusterOverrideBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ClusterOverride> buildClusterOverrides() {
    return this.clusterOverrides != null ? build(clusterOverrides) : null;
  }
  
  public ClusterOverride buildClusterOverride(int index) {
    return this.clusterOverrides.get(index).build();
  }
  
  public ClusterOverride buildFirstClusterOverride() {
    return this.clusterOverrides.get(0).build();
  }
  
  public ClusterOverride buildLastClusterOverride() {
    return this.clusterOverrides.get(clusterOverrides.size() - 1).build();
  }
  
  public ClusterOverride buildMatchingClusterOverride(Predicate<ClusterOverrideBuilder> predicate) {
      for (ClusterOverrideBuilder item : clusterOverrides) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingClusterOverride(Predicate<ClusterOverrideBuilder> predicate) {
      for (ClusterOverrideBuilder item : clusterOverrides) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withClusterOverrides(List<ClusterOverride> clusterOverrides) {
    if (this.clusterOverrides != null) {
      this._visitables.get("clusterOverrides").clear();
    }
    if (clusterOverrides != null) {
        this.clusterOverrides = new ArrayList();
        for (ClusterOverride item : clusterOverrides) {
          this.addToClusterOverrides(item);
        }
    } else {
      this.clusterOverrides = null;
    }
    return (A) this;
  }
  
  public A withClusterOverrides(io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.ClusterOverride... clusterOverrides) {
    if (this.clusterOverrides != null) {this.clusterOverrides.clear(); _visitables.remove("clusterOverrides"); }
    if (clusterOverrides != null) {for (ClusterOverride item :clusterOverrides){ this.addToClusterOverrides(item);}} return (A) this;
  }
  
  public boolean hasClusterOverrides() {
    return this.clusterOverrides != null && !this.clusterOverrides.isEmpty();
  }
  
  public ClusterOverridesNested<A> addNewClusterOverride() {
    return new ClusterOverridesNested(-1, null);
  }
  
  public ClusterOverridesNested<A> addNewClusterOverrideLike(ClusterOverride item) {
    return new ClusterOverridesNested(-1, item);
  }
  
  public ClusterOverridesNested<A> setNewClusterOverrideLike(int index,ClusterOverride item) {
    return new ClusterOverridesNested(index, item);
  }
  
  public ClusterOverridesNested<A> editClusterOverride(int index) {
    if (clusterOverrides.size() <= index) throw new RuntimeException("Can't edit clusterOverrides. Index exceeds size.");
    return setNewClusterOverrideLike(index, buildClusterOverride(index));
  }
  
  public ClusterOverridesNested<A> editFirstClusterOverride() {
    if (clusterOverrides.size() == 0) throw new RuntimeException("Can't edit first clusterOverrides. The list is empty.");
    return setNewClusterOverrideLike(0, buildClusterOverride(0));
  }
  
  public ClusterOverridesNested<A> editLastClusterOverride() {
    int index = clusterOverrides.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterOverrides. The list is empty.");
    return setNewClusterOverrideLike(index, buildClusterOverride(index));
  }
  
  public ClusterOverridesNested<A> editMatchingClusterOverride(Predicate<ClusterOverrideBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterOverrides.size();i++) { 
    if (predicate.test(clusterOverrides.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterOverrides. No match found.");
    return setNewClusterOverrideLike(index, buildClusterOverride(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterOverridesFluent that = (ClusterOverridesFluent) o;
    if (!java.util.Objects.equals(clusterName, that.clusterName)) return false;
    if (!java.util.Objects.equals(clusterOverrides, that.clusterOverrides)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterName,  clusterOverrides,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterName != null) { sb.append("clusterName:"); sb.append(clusterName + ","); }
    if (clusterOverrides != null && !clusterOverrides.isEmpty()) { sb.append("clusterOverrides:"); sb.append(clusterOverrides); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterOverridesNested<N> extends ClusterOverrideFluent<ClusterOverridesNested<N>> implements Nested<N>{
    ClusterOverridesNested(int index,ClusterOverride item) {
      this.index = index;
      this.builder = new ClusterOverrideBuilder(this, item);
    }
    ClusterOverrideBuilder builder;
    int index;
    
    public N and() {
      return (N) ClusterOverridesFluent.this.setToClusterOverrides(index,builder.build());
    }
    
    public N endClusterOverride() {
      return and();
    }
    
  
  }

}