package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SourceBuilder extends SourceFluent<SourceBuilder> implements VisitableBuilder<Source,SourceBuilder>{
  public SourceBuilder() {
    this(new Source());
  }
  
  public SourceBuilder(SourceFluent<?> fluent) {
    this(fluent, new Source());
  }
  
  public SourceBuilder(SourceFluent<?> fluent,Source instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SourceBuilder(Source instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SourceFluent<?> fluent;
  
  public Source build() {
    Source buildable = new Source(fluent.buildGit(),fluent.buildGithub(),fluent.buildHelmRepo(),fluent.getType());
    return buildable;
  }
  

}