package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GitHubBuilder extends GitHubFluent<GitHubBuilder> implements VisitableBuilder<GitHub,GitHubBuilder>{
  public GitHubBuilder() {
    this(new GitHub());
  }
  
  public GitHubBuilder(GitHubFluent<?> fluent) {
    this(fluent, new GitHub());
  }
  
  public GitHubBuilder(GitHubFluent<?> fluent,GitHub instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GitHubBuilder(GitHub instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GitHubFluent<?> fluent;
  
  public GitHub build() {
    GitHub buildable = new GitHub(fluent.getBranch(),fluent.getChartPath(),fluent.getUrls());
    return buildable;
  }
  

}