package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceSelectorBuilder extends ServiceSelectorFluent<ServiceSelectorBuilder> implements VisitableBuilder<ServiceSelector,ServiceSelectorBuilder>{
  public ServiceSelectorBuilder() {
    this(new ServiceSelector());
  }
  
  public ServiceSelectorBuilder(ServiceSelectorFluent<?> fluent) {
    this(fluent, new ServiceSelector());
  }
  
  public ServiceSelectorBuilder(ServiceSelectorFluent<?> fluent,ServiceSelector instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceSelectorBuilder(ServiceSelector instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceSelectorFluent<?> fluent;
  
  public ServiceSelector build() {
    ServiceSelector buildable = new ServiceSelector(fluent.getApiVersion(),fluent.getFieldPath(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getPath(),fluent.getPort(),fluent.getProtocol(),fluent.getResourceVersion(),fluent.getUid());
    return buildable;
  }
  

}