package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IngressSelectorBuilder extends IngressSelectorFluent<IngressSelectorBuilder> implements VisitableBuilder<IngressSelector,IngressSelectorBuilder>{
  public IngressSelectorBuilder() {
    this(new IngressSelector());
  }
  
  public IngressSelectorBuilder(IngressSelectorFluent<?> fluent) {
    this(fluent, new IngressSelector());
  }
  
  public IngressSelectorBuilder(IngressSelectorFluent<?> fluent,IngressSelector instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IngressSelectorBuilder(IngressSelector instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IngressSelectorFluent<?> fluent;
  
  public IngressSelector build() {
    IngressSelector buildable = new IngressSelector(fluent.getApiVersion(),fluent.getFieldPath(),fluent.getHost(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getPath(),fluent.getProtocol(),fluent.getResourceVersion(),fluent.getUid());
    return buildable;
  }
  

}