package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class InfoItemFluent<A extends InfoItemFluent<A>> extends BaseFluent<A>{
  public InfoItemFluent() {
  }
  
  public InfoItemFluent(InfoItem instance) {
    this.copyInstance(instance);
  }
  private String name;
  private String type;
  private String value;
  private InfoItemSourceBuilder valueFrom;
  
  protected void copyInstance(InfoItem instance) {
    instance = (instance != null ? instance : new InfoItem());
    if (instance != null) {
          this.withName(instance.getName());
          this.withType(instance.getType());
          this.withValue(instance.getValue());
          this.withValueFrom(instance.getValueFrom());
          this.withName(instance.getName());
          this.withType(instance.getType());
          this.withValue(instance.getValue());
          this.withValueFrom(instance.getValueFrom());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public String getValue() {
    return this.value;
  }
  
  public A withValue(String value) {
    this.value = value;
    return (A) this;
  }
  
  public boolean hasValue() {
    return this.value != null;
  }
  
  public InfoItemSource buildValueFrom() {
    return this.valueFrom != null ? this.valueFrom.build() : null;
  }
  
  public A withValueFrom(InfoItemSource valueFrom) {
    this._visitables.remove(this.valueFrom);
    if (valueFrom != null) {
        this.valueFrom = new InfoItemSourceBuilder(valueFrom);
        this._visitables.get("valueFrom").add(this.valueFrom);
    } else {
        this.valueFrom = null;
        this._visitables.get("valueFrom").remove(this.valueFrom);
    }
    return (A) this;
  }
  
  public boolean hasValueFrom() {
    return this.valueFrom != null;
  }
  
  public ValueFromNested<A> withNewValueFrom() {
    return new ValueFromNested(null);
  }
  
  public ValueFromNested<A> withNewValueFromLike(InfoItemSource item) {
    return new ValueFromNested(item);
  }
  
  public ValueFromNested<A> editValueFrom() {
    return withNewValueFromLike(java.util.Optional.ofNullable(buildValueFrom()).orElse(null));
  }
  
  public ValueFromNested<A> editOrNewValueFrom() {
    return withNewValueFromLike(java.util.Optional.ofNullable(buildValueFrom()).orElse(new InfoItemSourceBuilder().build()));
  }
  
  public ValueFromNested<A> editOrNewValueFromLike(InfoItemSource item) {
    return withNewValueFromLike(java.util.Optional.ofNullable(buildValueFrom()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InfoItemFluent that = (InfoItemFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(value, that.value)) return false;
    if (!java.util.Objects.equals(valueFrom, that.valueFrom)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  type,  value,  valueFrom,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (value != null) { sb.append("value:"); sb.append(value + ","); }
    if (valueFrom != null) { sb.append("valueFrom:"); sb.append(valueFrom); }
    sb.append("}");
    return sb.toString();
  }
  public class ValueFromNested<N> extends InfoItemSourceFluent<ValueFromNested<N>> implements Nested<N>{
    ValueFromNested(InfoItemSource item) {
      this.builder = new InfoItemSourceBuilder(this, item);
    }
    InfoItemSourceBuilder builder;
    
    public N and() {
      return (N) InfoItemFluent.this.withValueFrom(builder.build());
    }
    
    public N endValueFrom() {
      return and();
    }
    
  
  }

}